/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.FMHyperParameters;
import hivemall.factorization.fm.FactorizationMachineModel;
import hivemall.factorization.fm.Feature;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public final class FMArrayModel
extends FactorizationMachineModel {
    private final int _p;
    @Nonnull
    private final float[] _w;
    @Nonnull
    private final float[][] _V;

    public FMArrayModel(@Nonnull FMHyperParameters params) {
        super(params);
        this._p = params.numFeatures;
        this._w = new float[params.numFeatures + 1];
        this._V = new float[params.numFeatures][];
    }

    @Override
    protected int getMinIndex() {
        return 1;
    }

    @Override
    protected int getMaxIndex() {
        return this._p - 1;
    }

    @Override
    public int getSize() {
        return this._p;
    }

    @Override
    public float getW0() {
        return this._w[0];
    }

    @Override
    protected void setW0(float nextW0) {
        this._w[0] = nextW0;
    }

    @Override
    protected float getW(int i) {
        assert (i >= 1) : i;
        return this._w[i];
    }

    @Override
    public float getW(@Nonnull Feature x) {
        int i = x.getFeatureIndex();
        assert (i >= 0) : i;
        return this._w[i];
    }

    @Override
    protected void setW(@Nonnull Feature x, float nextWi) {
        int i = x.getFeatureIndex();
        assert (i >= 0) : i;
        this._w[i] = nextWi;
    }

    @Override
    protected float[] getV(int i, boolean init) {
        if (i < 1 || i > this._p) {
            throw new IllegalArgumentException("Index i should be in range [1," + this._p + "]: " + i);
        }
        int idx = i - 1;
        float[] v = this._V[idx];
        if (v == null && init) {
            v = this.initV();
            this._V[idx] = v;
        }
        return v;
    }

    @Override
    public float getV(@Nonnull Feature x, int f) {
        int i = x.getFeatureIndex();
        float[] v = this.getV(i, true);
        return v[f];
    }

    @Override
    protected void setV(@Nonnull Feature x, int f, float nextVif) {
        int i = x.getFeatureIndex();
        float[] v = this.getV(i, true);
        v[f] = nextVif;
    }

    @Override
    public void check(@Nonnull Feature[] x) throws HiveException {
        for (Feature e : x) {
            if (e == null || e.getFeatureIndex() >= 1) continue;
            throw new HiveException("Index of x should be greater than or equals to 1: " + Arrays.toString(x));
        }
    }
}

