/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.FMHyperParameters;
import hivemall.factorization.fm.FactorizationMachineModel;
import hivemall.factorization.fm.Feature;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public final class FMIntFeatureMapModel
extends FactorizationMachineModel {
    private static final int DEFAULT_MAPSIZE = 4096;
    private float _w0 = 0.0f;
    @Nonnull
    private final Int2FloatMap _w = new Int2FloatOpenHashMap(4096);
    @Nonnull
    private final Int2ObjectMap<float[]> _V;
    private int _minIndex;
    private int _maxIndex;

    public FMIntFeatureMapModel(@Nonnull FMHyperParameters params) {
        super(params);
        this._w.defaultReturnValue(0.0f);
        this._V = new Int2ObjectOpenHashMap<float[]>(4096);
        this._minIndex = 0;
        this._maxIndex = 0;
    }

    @Override
    public int getSize() {
        return this._w.size();
    }

    @Override
    protected int getMinIndex() {
        return this._minIndex;
    }

    @Override
    protected int getMaxIndex() {
        return this._maxIndex;
    }

    @Override
    public float getW0() {
        return this._w0;
    }

    @Override
    protected void setW0(float nextW0) {
        this._w0 = nextW0;
    }

    @Override
    protected float getW(int i) {
        assert (i >= 1) : i;
        return this._w.get(i);
    }

    @Override
    public float getW(@Nonnull Feature x) {
        int i = x.getFeatureIndex();
        if (i == 0) {
            return this._w0;
        }
        assert (i >= 1) : i;
        return this._w.get(i);
    }

    @Override
    protected void setW(@Nonnull Feature x, float nextWi) {
        int i = x.getFeatureIndex();
        if (i == 0) {
            this._w0 = nextWi;
        } else {
            assert (i >= 1) : i;
            this._w.put(i, nextWi);
        }
    }

    @Override
    protected float[] getV(int i, boolean init) {
        assert (i >= 1) : i;
        return (float[])this._V.get(i);
    }

    @Override
    public float getV(@Nonnull Feature x, int f) {
        int i = x.getFeatureIndex();
        assert (i >= 1) : i;
        float[] Vi = (float[])this._V.get(i);
        if (Vi == null) {
            return 0.0f;
        }
        return Vi[f];
    }

    @Override
    protected void setV(@Nonnull Feature x, int f, float nextVif) {
        int i = x.getFeatureIndex();
        assert (i >= 1) : i;
        float[] vi = (float[])this._V.get(i);
        assert (vi != null) : "V[" + i + "] was null";
        vi[f] = nextVif;
    }

    @Override
    public void check(@Nonnull Feature[] x) throws HiveException {
        for (Feature e : x) {
            if (e == null) continue;
            int idx = e.getFeatureIndex();
            if (idx < 1) {
                throw new HiveException("Index of x should be greater than or equals to 1: " + Arrays.toString(x));
            }
            if (!this._w.containsKey(idx)) {
                this._w.put(idx, 0.0f);
            }
            if (!this._V.containsKey(idx)) {
                float[] tmp = this.initV();
                this._V.put(idx, tmp);
            }
            this._maxIndex = Math.max(this._maxIndex, idx);
            this._minIndex = Math.min(this._minIndex, idx);
        }
    }
}

