/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.IntFeature;
import hivemall.factorization.fm.StringFeature;
import hivemall.utils.hashing.MurmurHash3;
import hivemall.utils.lang.NumberUtils;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;

public abstract class Feature {
    public static final int DEFAULT_NUM_FIELDS = 256;
    public static final int DEFAULT_FEATURE_BITS = 21;
    public static final int DEFAULT_NUM_FEATURES = 0x200000;
    protected double value;

    public Feature() {
    }

    public Feature(double value) {
        this.value = value;
    }

    public void setFeature(@Nonnull String f) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public String getFeature() {
        throw new UnsupportedOperationException();
    }

    public void setFeatureIndex(@Nonnegative int i) {
        throw new UnsupportedOperationException();
    }

    @Nonnegative
    public int getFeatureIndex() {
        throw new UnsupportedOperationException();
    }

    public short getField() {
        throw new UnsupportedOperationException();
    }

    public void setField(short field) {
        throw new UnsupportedOperationException();
    }

    public double getValue() {
        return this.value;
    }

    public abstract int bytes();

    public abstract void writeTo(@Nonnull ByteBuffer var1);

    public abstract void readFrom(@Nonnull ByteBuffer var1);

    public static int requiredBytes(@Nonnull Feature[] x) {
        int ret = 0;
        for (Feature f : x) {
            assert (f != null);
            ret += f.bytes();
        }
        return ret;
    }

    @Nullable
    public static Feature[] parseFeatures(@Nonnull Object arg, @Nonnull ListObjectInspector listOI, @Nullable Feature[] probes, boolean asIntFeature) throws HiveException {
        if (arg == null) {
            return null;
        }
        int length = listOI.getListLength(arg);
        Feature[] ary = probes != null && probes.length == length ? probes : new Feature[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(arg, i);
            if (o == null) continue;
            String s = o.toString();
            Feature f = ary[j];
            if (f == null) {
                f = Feature.parseFeature(s, asIntFeature);
            } else {
                Feature.parseFeature(s, f, asIntFeature);
            }
            ary[j] = f;
            ++j;
        }
        if (j == length) {
            return ary;
        }
        Feature[] dst = new Feature[j];
        System.arraycopy(ary, 0, dst, 0, j);
        return dst;
    }

    @Nullable
    public static Feature[] parseFFMFeatures(@Nonnull Object arg, @Nonnull ListObjectInspector listOI, @Nullable Feature[] probes, int numFeatures, int numFields) throws HiveException {
        if (arg == null) {
            return null;
        }
        int length = listOI.getListLength(arg);
        Feature[] ary = probes != null && probes.length == length ? probes : new Feature[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(arg, i);
            if (o == null) continue;
            String s = o.toString();
            Feature f = ary[j];
            if (f == null) {
                f = Feature.parseFFMFeature(s, numFeatures, numFields);
            } else {
                Feature.parseFFMFeature(s, f, numFeatures, numFields);
            }
            ary[j] = f;
            ++j;
        }
        if (j == length) {
            return ary;
        }
        Feature[] dst = new Feature[j];
        System.arraycopy(ary, 0, dst, 0, j);
        return dst;
    }

    @Nonnull
    static Feature parseFeature(@Nonnull String fv, boolean asIntFeature) throws HiveException {
        int pos1 = fv.indexOf(58);
        if (pos1 == -1) {
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(fv);
                return new IntFeature(index, 1.0);
            }
            if ("0".equals(fv)) {
                throw new HiveException("Index value should not be 0: " + fv);
            }
            return new StringFeature(fv, 1.0);
        }
        String indexStr = fv.substring(0, pos1);
        String valueStr = fv.substring(pos1 + 1);
        if (asIntFeature) {
            int index = Feature.parseFeatureIndex(indexStr);
            double value = Feature.parseFeatureValue(valueStr);
            return new IntFeature(index, value);
        }
        double value = Feature.parseFeatureValue(valueStr);
        if ("0".equals(indexStr)) {
            throw new HiveException("Index value should not be 0: " + fv);
        }
        return new StringFeature(indexStr, value);
    }

    @Nonnull
    static IntFeature parseFFMFeature(@Nonnull String fv) throws HiveException {
        return Feature.parseFFMFeature(fv, 0x200000, 256);
    }

    @Nonnull
    static IntFeature parseFFMFeature(@Nonnull String fv, int numFeatures) throws HiveException {
        return Feature.parseFFMFeature(fv, -1, 256);
    }

    @Nonnull
    static IntFeature parseFFMFeature(@Nonnull String fv, int numFeatures, int numFields) throws HiveException {
        int pos1 = fv.indexOf(58);
        if (pos1 == -1) {
            throw new HiveException("Invalid FFM feature format: " + fv);
        }
        String lead = fv.substring(0, pos1);
        String rest = fv.substring(pos1 + 1);
        int pos2 = rest.indexOf(58);
        if (pos2 == -1) {
            throw new HiveException("Invalid FFM feature representation. Expected <field>:<index>:<value> but got " + fv);
        }
        short field = NumberUtils.isDigits(lead) ? Feature.parseField(lead, numFields) : NumberUtils.castToShort(MurmurHash3.murmurhash3(lead, numFields));
        String indexStr = rest.substring(0, pos2);
        int index = numFeatures == -1 && NumberUtils.isDigits(indexStr) ? Feature.parseFeatureIndex(indexStr) : MurmurHash3.murmurhash3(indexStr, numFeatures) + numFields;
        String valueStr = rest.substring(pos2 + 1);
        double value = Feature.parseFeatureValue(valueStr);
        return new IntFeature(index, field, value);
    }

    static void parseFeature(@Nonnull String fv, @Nonnull Feature probe, boolean asIntFeature) throws HiveException {
        int pos1 = fv.indexOf(":");
        if (pos1 == -1) {
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(fv);
                probe.setFeatureIndex(index);
            } else {
                if ("0".equals(fv)) {
                    throw new HiveException("Index value should not be 0: " + fv);
                }
                probe.setFeature(fv);
            }
            probe.value = 1.0;
        } else {
            String indexStr = fv.substring(0, pos1);
            String valueStr = fv.substring(pos1 + 1);
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(indexStr);
                probe.setFeatureIndex(index);
                probe.value = Feature.parseFeatureValue(valueStr);
            } else {
                if ("0".equals(indexStr)) {
                    throw new HiveException("Index value should not be 0: " + fv);
                }
                probe.setFeature(indexStr);
                probe.value = Feature.parseFeatureValue(valueStr);
            }
        }
    }

    static void parseFFMFeature(@Nonnull String fv, @Nonnull Feature probe) throws HiveException {
        Feature.parseFFMFeature(fv, probe, 0x200000, 256);
    }

    static void parseFFMFeature(@Nonnull String fv, @Nonnull Feature probe, int numFeatures, int numFields) throws HiveException {
        int pos1 = fv.indexOf(":");
        if (pos1 == -1) {
            throw new HiveException("Invalid FFM feature format: " + fv);
        }
        String lead = fv.substring(0, pos1);
        String rest = fv.substring(pos1 + 1);
        int pos2 = rest.indexOf(58);
        if (pos2 == -1) {
            throw new HiveException("Invalid FFM feature representation. Expected <field>:<index>:<value> but got " + fv);
        }
        short field = NumberUtils.isDigits(lead) ? Feature.parseField(lead, numFields) : NumberUtils.castToShort(MurmurHash3.murmurhash3(lead, numFields));
        String indexStr = rest.substring(0, pos2);
        int index = numFeatures == -1 && NumberUtils.isDigits(indexStr) ? Feature.parseFeatureIndex(indexStr) : MurmurHash3.murmurhash3(indexStr, numFeatures) + numFields;
        probe.setField(field);
        probe.setFeatureIndex(index);
        String valueStr = rest.substring(pos2 + 1);
        probe.value = Feature.parseFeatureValue(valueStr);
    }

    private static int parseFeatureIndex(@Nonnull String indexStr) throws HiveException {
        int index;
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid index value: " + indexStr, (Throwable)e);
        }
        if (index <= 0) {
            throw new HiveException("Feature index MUST be greater than 0: " + indexStr);
        }
        return index;
    }

    private static double parseFeatureValue(@Nonnull String value) throws HiveException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid feature value: " + value, (Throwable)e);
        }
    }

    private static short parseField(@Nonnull String fieldStr, int numFields) throws HiveException {
        short field;
        try {
            field = Short.parseShort(fieldStr);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid field value: " + fieldStr, (Throwable)e);
        }
        if (field < 0 || field >= numFields) {
            throw new HiveException("Invalid field value: " + fieldStr);
        }
        return field;
    }

    public static int toIntFeature(@Nonnull Feature x) {
        int index = x.getFeatureIndex();
        return -index;
    }

    public static int toIntFeature(@Nonnull Feature x, @Nonnegative int yField, @Nonnegative int numFields) {
        int index = x.getFeatureIndex();
        return index * numFields + yField;
    }

    public static void l2normalize(@Nonnull Feature[] features) {
        double squaredSum = 0.0;
        for (Feature f : features) {
            double v = f.value;
            squaredSum += v * v;
        }
        if (squaredSum == 0.0) {
            return;
        }
        double invNorm = 1.0 / Math.sqrt(squaredSum);
        for (Feature f : features) {
            f.value *= invNorm;
        }
    }
}

