/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.Entry;
import hivemall.factorization.fm.FFMStringFeatureMapModel;
import hivemall.factorization.fm.FMHyperParameters;
import hivemall.factorization.fm.FactorizationMachineUDTF;
import hivemall.factorization.fm.Feature;
import hivemall.factorization.fm.IntFeature;
import hivemall.utils.collections.Fastutil;
import hivemall.utils.collections.arrays.DoubleArray3D;
import hivemall.utils.collections.lists.IntArrayList;
import hivemall.utils.hadoop.HadoopUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.math.MathUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="train_ffm", value="_FUNC_(array<string> x, double y [, const string options]) - Returns a prediction model")
public final class FieldAwareFactorizationMachineUDTF
extends FactorizationMachineUDTF {
    private static final Log LOG = LogFactory.getLog(FieldAwareFactorizationMachineUDTF.class);
    private boolean _globalBias;
    private boolean _linearCoeff;
    private int _numFeatures;
    private int _numFields;
    protected transient FFMStringFeatureMapModel _ffmModel;
    private transient IntArrayList _fieldList;
    @Nullable
    private transient DoubleArray3D _sumVfX;

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("w0", "global_bias", false, "Whether to include global bias term w0 [default: OFF]");
        opts.addOption("enable_wi", "linear_term", false, "Include linear term [default: OFF]");
        opts.addOption("no_norm", "disable_norm", false, "Disable instance-wise L2 normalization");
        opts.addOption("feature_hashing", true, "The number of bits for feature hashing in range [18,31] [default: -1]. No feature hashing for -1.");
        opts.addOption("num_fields", true, "The number of fields [default: 256]");
        opts.addOption("opt", "optimizer", true, "Gradient Descent optimizer [default: ftrl, adagrad, sgd]");
        opts.addOption("eps", true, "A constant used in the denominator of AdaGrad [default: 1.0]");
        opts.addOption("alpha", "alphaFTRL", true, "Alpha value (learning rate) of Follow-The-Regularized-Reader [default: 0.5]");
        opts.addOption("beta", "betaFTRL", true, "Beta value (a learning smoothing parameter) of Follow-The-Regularized-Reader [default: 1.0]");
        opts.addOption("l1", "lambda1", true, "L1 regularization value of Follow-The-Regularized-Reader that controls model Sparseness [default: 0.0002]");
        opts.addOption("l2", "lambda2", true, "L2 regularization value of Follow-The-Regularized-Reader [default: 0.0001]");
        return opts;
    }

    @Override
    protected boolean isAdaptiveRegularizationSupported() {
        return false;
    }

    @Override
    protected FMHyperParameters.FFMHyperParameters newHyperParameters() {
        return new FMHyperParameters.FFMHyperParameters();
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        FMHyperParameters.FFMHyperParameters params = (FMHyperParameters.FFMHyperParameters)this._params;
        this._globalBias = params.globalBias;
        this._linearCoeff = params.linearCoeff;
        this._numFeatures = params.numFeatures;
        this._numFields = params.numFields;
        return cl;
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        StructObjectInspector oi = super.initialize(argOIs);
        this._fieldList = new IntArrayList();
        return oi;
    }

    @Override
    protected StructObjectInspector getOutputOI(@Nonnull FMHyperParameters params) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Object> fieldOIs = new ArrayList<Object>();
        fieldNames.add("model_id");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        fieldNames.add("i");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldNames.add("Wi");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        fieldNames.add("Vi");
        fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector));
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    protected FFMStringFeatureMapModel initModel(@Nonnull FMHyperParameters params) throws UDFArgumentException {
        FFMStringFeatureMapModel model;
        FMHyperParameters.FFMHyperParameters ffmParams = (FMHyperParameters.FFMHyperParameters)params;
        this._ffmModel = model = new FFMStringFeatureMapModel(ffmParams);
        return model;
    }

    @Override
    protected Feature[] parseFeatures(@Nonnull Object arg) throws HiveException {
        Feature[] features = Feature.parseFFMFeatures(arg, this._xOI, this._probes, this._numFeatures, this._numFields);
        if (this._params.l2norm) {
            Feature.l2normalize(features);
        }
        return features;
    }

    @Override
    protected void processValidationSample(@Nonnull Feature[] x, double y) throws HiveException {
        if (this._earlyStopping) {
            double p = this._model.predict(x);
            double loss = this._lossFunction.loss(p, y);
            this._validationState.incrLoss(loss);
        }
    }

    @Override
    protected void trainTheta(@Nonnull Feature[] x, double y) throws HiveException {
        double p = this._ffmModel.predict(x);
        double lossGrad = this._ffmModel.dloss(p, y);
        double loss = this._lossFunction.loss(p, y);
        this._cvState.incrLoss(loss);
        if (MathUtils.closeToZero(lossGrad, 1.0E-9)) {
            return;
        }
        if (this._globalBias) {
            float eta_t = this._etaEstimator.eta(this._t);
            this._ffmModel.updateW0(lossGrad, eta_t);
        }
        IntArrayList fieldList = this.getFieldList(x);
        DoubleArray3D sumVfX = this._ffmModel.sumVfX(x, fieldList, this._sumVfX);
        for (int i = 0; i < x.length; ++i) {
            Feature x_i = x[i];
            if (x_i.value == 0.0) continue;
            if (this._linearCoeff) {
                this._ffmModel.updateWi(lossGrad, x_i, this._t);
            }
            int size = fieldList.size();
            for (int fieldIndex = 0; fieldIndex < size; ++fieldIndex) {
                int yField = fieldList.get(fieldIndex);
                int k = this._factors;
                for (int f = 0; f < k; ++f) {
                    double sumViX = sumVfX.get(i, fieldIndex, f);
                    if (MathUtils.closeToZero(sumViX)) continue;
                    this._ffmModel.updateV(lossGrad, x_i, yField, f, sumViX, this._t);
                }
            }
        }
        sumVfX.clear();
        this._sumVfX = sumVfX;
        fieldList.clear();
    }

    @Nonnull
    private IntArrayList getFieldList(@Nonnull Feature[] x) {
        for (Feature e : x) {
            short field = e.getField();
            this._fieldList.add(field);
        }
        return this._fieldList;
    }

    @Override
    protected IntFeature instantiateFeature(@Nonnull ByteBuffer input) {
        return new IntFeature(input);
    }

    @Override
    public void close() throws HiveException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)this._ffmModel.getStatistics());
        }
        this._ffmModel.disableInitV();
        super.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)this._ffmModel.getStatistics());
        }
        this._ffmModel = null;
    }

    @Override
    protected void forwardModel() throws HiveException {
        this._model = null;
        this._fieldList = null;
        this._sumVfX = null;
        int factors = this._factors;
        IntWritable idx = new IntWritable();
        FloatWritable Wi = new FloatWritable(0.0f);
        FloatWritable[] Vi = HiveUtils.newFloatArray(factors, 0.0f);
        List<FloatWritable> ViObj = Arrays.asList(Vi);
        Object[] forwardObjs = new Object[4];
        String modelId = HadoopUtils.getUniqueTaskIdString();
        forwardObjs[0] = new Text(modelId);
        forwardObjs[1] = idx;
        forwardObjs[2] = Wi;
        forwardObjs[3] = null;
        idx.set(0);
        Wi.set(this._ffmModel.getW0());
        this.forward(forwardObjs);
        Entry entryW = new Entry(this._ffmModel._buf, 1);
        Entry entryV = new Entry(this._ffmModel._buf, factors);
        float[] Vf = new float[factors];
        for (Int2LongMap.Entry e : Fastutil.fastIterable(this._ffmModel._map)) {
            int i = e.getIntKey();
            idx.set(i);
            long offset = e.getLongValue();
            if (Entry.isEntryW(i)) {
                entryW.setOffset(offset);
                float w = entryW.getW();
                if (w == 0.0f) continue;
                Wi.set(w);
                forwardObjs[2] = Wi;
                forwardObjs[3] = null;
            } else {
                entryV.setOffset(offset);
                entryV.getV(Vf);
                for (int f = 0; f < factors; ++f) {
                    Vi[f].set(Vf[f]);
                }
                forwardObjs[2] = null;
                forwardObjs[3] = ViObj;
            }
            this.forward(forwardObjs);
        }
    }
}

