/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.Feature;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class IntFeature
extends Feature {
    @Nonnegative
    private int index;
    private short field;

    public IntFeature(@Nonnegative int index, double value) {
        this(index, -1, value);
    }

    public IntFeature(@Nonnegative int index, short field, double value) {
        super(value);
        this.field = field;
        this.index = index;
    }

    public IntFeature(@Nonnull ByteBuffer src) {
        this.readFrom(src);
    }

    @Override
    public String getFeature() {
        return Integer.toString(this.index);
    }

    @Override
    public int getFeatureIndex() {
        return this.index;
    }

    @Override
    public void setFeatureIndex(int i) {
        this.index = i;
    }

    @Override
    public short getField() {
        return this.field;
    }

    @Override
    public void setField(short field) {
        this.field = field;
    }

    @Override
    public int bytes() {
        return 14;
    }

    @Override
    public void writeTo(@Nonnull ByteBuffer dst) {
        dst.putInt(this.index);
        dst.putShort(this.field);
        dst.putDouble(this.value);
    }

    @Override
    public void readFrom(@Nonnull ByteBuffer src) {
        this.index = src.getInt();
        this.field = src.getShort();
        this.value = src.getDouble();
    }

    public String toString() {
        if (this.field == -1) {
            return this.index + ":" + this.value;
        }
        return this.field + ":" + this.index + ":" + this.value;
    }
}

