/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.Feature;
import hivemall.utils.io.NIOUtils;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class StringFeature
extends Feature {
    @Nonnull
    protected String feature;

    public StringFeature(@Nonnull String feature, double value) {
        super(value);
        this.feature = feature;
    }

    StringFeature(int feature, double value) {
        this(String.valueOf(feature), value);
    }

    public StringFeature(@Nonnull ByteBuffer src) {
        this.readFrom(src);
    }

    @Override
    public String getFeature() {
        return this.feature;
    }

    @Override
    public void setFeature(@Nonnull String feature) {
        this.feature = feature;
    }

    @Override
    public int bytes() {
        return NIOUtils.requiredBytes(this.feature) + 8;
    }

    @Override
    public void writeTo(@Nonnull ByteBuffer dst) {
        NIOUtils.putString(this.feature, dst);
        dst.putDouble(this.value);
    }

    @Override
    public void readFrom(@Nonnull ByteBuffer src) {
        this.feature = NIOUtils.getString(src);
        this.value = src.getDouble();
    }

    public String toString() {
        return this.feature + ':' + this.value;
    }
}

