/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.mf;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;

@Description(name="mf_predict", value="_FUNC_(List<Float> Pu, List<Float> Qi[, double Bu, double Bi[, double mu]]) - Returns the prediction value")
@UDFType(deterministic=true, stateful=false)
public final class MFPredictionUDF
extends UDF {
    @Nonnull
    public DoubleWritable evaluate(@Nullable List<FloatWritable> Pu, @Nullable List<FloatWritable> Qi) throws HiveException {
        return this.evaluate(Pu, Qi, null);
    }

    @Nonnull
    public DoubleWritable evaluate(@Nullable List<FloatWritable> Pu, @Nullable List<FloatWritable> Qi, @Nullable DoubleWritable mu) throws HiveException {
        double muValue;
        double d = muValue = mu == null ? 0.0 : mu.get();
        if (Pu == null || Qi == null) {
            return new DoubleWritable(muValue);
        }
        int PuSize = Pu.size();
        int QiSize = Qi.size();
        if (PuSize == 0) {
            return new DoubleWritable(muValue);
        }
        if (QiSize == 0) {
            return new DoubleWritable(muValue);
        }
        if (QiSize != PuSize) {
            throw new HiveException("|Pu| " + PuSize + " was not equal to |Qi| " + QiSize);
        }
        double ret = muValue;
        for (int k = 0; k < PuSize; ++k) {
            FloatWritable Qi_k;
            FloatWritable Pu_k = Pu.get(k);
            if (Pu_k == null || (Qi_k = Qi.get(k)) == null) continue;
            ret += (double)(Pu_k.get() * Qi_k.get());
        }
        return new DoubleWritable(ret);
    }

    @Nonnull
    public DoubleWritable evaluate(@Nullable List<FloatWritable> Pu, @Nullable List<FloatWritable> Qi, @Nullable DoubleWritable Bu, @Nullable DoubleWritable Bi) throws HiveException {
        return this.evaluate(Pu, Qi, Bu, Bi, null);
    }

    @Nonnull
    public DoubleWritable evaluate(@Nullable List<FloatWritable> Pu, @Nullable List<FloatWritable> Qi, @Nullable DoubleWritable Bu, @Nullable DoubleWritable Bi, @Nullable DoubleWritable mu) throws HiveException {
        double BuValue;
        double muValue;
        double d = muValue = mu == null ? 0.0 : mu.get();
        if (Pu == null && Qi == null) {
            return new DoubleWritable(muValue);
        }
        double BiValue = Bi == null ? 0.0 : Bi.get();
        double d2 = BuValue = Bu == null ? 0.0 : Bu.get();
        if (Pu == null) {
            double ret = muValue + BiValue;
            return new DoubleWritable(ret);
        }
        if (Qi == null) {
            return new DoubleWritable(muValue);
        }
        int PuSize = Pu.size();
        int QiSize = Qi.size();
        if (PuSize == 0) {
            if (QiSize == 0) {
                return new DoubleWritable(muValue);
            }
            double ret = muValue + BiValue;
            return new DoubleWritable(ret);
        }
        if (QiSize == 0) {
            double ret = muValue + BuValue;
            return new DoubleWritable(ret);
        }
        if (QiSize != PuSize) {
            throw new HiveException("|Pu| " + PuSize + " was not equal to |Qi| " + QiSize);
        }
        double ret = muValue + BuValue + BiValue;
        for (int k = 0; k < PuSize; ++k) {
            FloatWritable Qi_k;
            FloatWritable Pu_k = Pu.get(k);
            if (Pu_k == null || (Qi_k = Qi.get(k)) == null) continue;
            ret += (double)(Pu_k.get() * Qi_k.get());
        }
        return new DoubleWritable(ret);
    }
}

