/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="add_feature_index", value="_FUNC_(ARRAY[DOUBLE]: dense feature vector) - Returns a feature vector with feature indices")
@UDFType(deterministic=true, stateful=false)
public final class AddFeatureIndexUDF
extends UDF {
    public List<Text> evaluate(List<Double> ftvec) {
        if (ftvec == null) {
            return null;
        }
        int size = ftvec.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        Text[] array = new Text[size];
        for (int i = 0; i < size; ++i) {
            Double v = ftvec.get(i);
            array[i] = new Text(String.valueOf(i + 1) + ':' + v);
        }
        return Arrays.asList(array);
    }
}

