/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import hivemall.utils.hadoop.WritableUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="extract_feature", value="_FUNC_(feature_vector in array<string>) - Returns features in array<string>")
@UDFType(deterministic=true, stateful=false)
public class ExtractFeatureUDF
extends UDF {
    public Text evaluate(String featureVector) {
        if (featureVector == null) {
            return null;
        }
        return WritableUtils.val(ExtractFeatureUDF.extractFeature(featureVector));
    }

    public List<Text> evaluate(List<String> featureVectors) {
        if (featureVectors == null) {
            return null;
        }
        int size = featureVectors.size();
        Text[] output = new Text[size];
        for (int i = 0; i < size; ++i) {
            String fv = featureVectors.get(i);
            if (fv == null) continue;
            output[i] = new Text(ExtractFeatureUDF.extractFeature(fv));
        }
        return Arrays.asList(output);
    }

    public static String extractFeature(String ftvec) {
        int pos = ftvec.indexOf(":");
        if (pos > 0) {
            return ftvec.substring(0, pos);
        }
        return ftvec;
    }
}

