/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="feature_index", value="_FUNC_(feature_vector in array<string>) - Returns feature indices in array<index>")
@UDFType(deterministic=true, stateful=false)
public final class FeatureIndexUDF
extends UDF {
    @Nullable
    public IntWritable evaluate(@Nullable String feature) throws HiveException {
        if (feature == null) {
            return null;
        }
        int idx = FeatureIndexUDF.featureIndex(feature);
        return new IntWritable(idx);
    }

    @Nullable
    public List<IntWritable> evaluate(@Nullable List<String> featureVector) throws HiveException {
        if (featureVector == null) {
            return null;
        }
        int size = featureVector.size();
        ArrayList<IntWritable> list = new ArrayList<IntWritable>(size);
        for (String f : featureVector) {
            if (f == null) continue;
            int fi = FeatureIndexUDF.featureIndex(f);
            list.add(new IntWritable(fi));
        }
        return list;
    }

    private static int featureIndex(@Nonnull String feature) throws HiveException {
        String f = FeatureIndexUDF.extractFeature(feature);
        try {
            return Integer.parseInt(f);
        }
        catch (NumberFormatException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Nonnull
    private static String extractFeature(@Nonnull String feature) {
        int pos = feature.indexOf(":");
        if (pos > 0) {
            return feature.substring(0, pos);
        }
        return feature;
    }
}

