/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import hivemall.utils.hadoop.HiveUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="feature", value="_FUNC_(<string|int|long|short|byte> feature, <number> value) - Returns a feature string")
@UDFType(deterministic=true, stateful=false)
public final class FeatureUDF
extends GenericUDF {
    @Nullable
    private Text _result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("_FUNC_ takes exactly 2 arguments, feature index and value");
        }
        FeatureUDF.validateFeatureOI(argOIs[0]);
        FeatureUDF.validateValueOI(argOIs[1]);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    private static void validateFeatureOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!HiveUtils.isPrimitiveOI(argOI)) {
            throw new UDFArgumentException("_FUNC_ expects integer type or string for `feature` but got " + argOI.getTypeName());
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case INT: 
            case SHORT: 
            case LONG: 
            case BYTE: 
            case STRING: {
                break;
            }
            default: {
                throw new UDFArgumentException("_FUNC_ expects integer type or string for `feature` but got " + argOI.getTypeName());
            }
        }
    }

    private static void validateValueOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!HiveUtils.isNumberOI(argOI)) {
            throw new UDFArgumentException("_FUNC_ expects a number type for `value` but got " + argOI.getTypeName());
        }
    }

    @Nullable
    public Text evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        assert (args.length == 2) : args.length;
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        Object arg1 = args[1].get();
        if (arg1 == null) {
            return null;
        }
        String featureStr = arg0.toString();
        if (featureStr.indexOf(58) >= 0) {
            throw new UDFArgumentException("feature name SHOULD NOT contain colon: " + featureStr);
        }
        String valueStr = arg1.toString();
        String fv = featureStr + ':' + valueStr;
        Text result = this._result;
        if (result == null) {
            this._result = result = new Text(fv);
        } else {
            result.set(fv);
        }
        return result;
    }

    public String getDisplayString(@Nonnull String[] children) {
        return "feature(" + children[0] + ", " + children[1] + ")";
    }
}

