/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.amplify;

import hivemall.UDTFWithOptions;
import hivemall.common.RandomizedAmplifier;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Primitives;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="rand_amplify", value="_FUNC_(const int xtimes [, const string options], *) - amplify the input records x-times in map-side")
public final class RandomAmplifierUDTF
extends UDTFWithOptions
implements RandomizedAmplifier.DropoutListener<Object[]> {
    private boolean hasOption = false;
    private long seed = -1L;
    private int numBuffers = 1000;
    private transient ObjectInspector[] argOIs;
    private transient RandomizedAmplifier<Object[]> amplifier;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("seed", true, "Random seed value [default: -1L (random)]");
        opts.addOption("buf", "num_buffers", true, "The number of rows to keep in a buffer [default: 1000]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = null;
        if (argOIs.length >= 3 && HiveUtils.isConstString(argOIs[1])) {
            String rawArgs = HiveUtils.getConstString(argOIs[1]);
            cl = this.parseOptions(rawArgs);
            this.hasOption = true;
            this.seed = Primitives.parseLong(cl.getOptionValue("seed"), this.seed);
            this.numBuffers = Primitives.parseInt(cl.getOptionValue("num_buffers"), this.numBuffers);
        }
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int argStartIndex;
        int numArgs = argOIs.length;
        if (numArgs < 2) {
            throw new UDFArgumentException("_FUNC_(const int xtimes, [, const string options], *) takes at least two arguments");
        }
        int xtimes = HiveUtils.getAsConstInt(argOIs[0]);
        if (xtimes < 1) {
            throw new UDFArgumentException("Illegal xtimes value: " + xtimes);
        }
        this.argOIs = argOIs;
        this.processOptions(argOIs);
        this.amplifier = this.seed == -1L ? new RandomizedAmplifier(this.numBuffers, xtimes) : new RandomizedAmplifier(this.numBuffers, xtimes, this.seed);
        this.amplifier.setDropoutListener(this);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (int i = argStartIndex = this.hasOption ? 2 : 1; i < numArgs; ++i) {
            fieldNames.add("c" + (i - 1));
            ObjectInspector rawOI = argOIs[i];
            ObjectInspector retOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)rawOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.DEFAULT);
            fieldOIs.add(retOI);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        int argStartIndex = this.hasOption ? 2 : 1;
        Object[] row = new Object[args.length - argStartIndex];
        for (int i = argStartIndex; i < args.length; ++i) {
            Object arg = args[i];
            ObjectInspector argOI = this.argOIs[i];
            row[i - argStartIndex] = ObjectInspectorUtils.copyToStandardObject((Object)arg, (ObjectInspector)argOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.DEFAULT);
        }
        this.amplifier.add(row);
    }

    public void close() throws HiveException {
        this.amplifier.sweepAll();
        this.amplifier = null;
    }

    @Override
    public void onDrop(Object[] row) throws HiveException {
        this.forward(row);
    }
}

