/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.binning;

import hivemall.ftvec.binning.NumericHistogram;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.lang.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="build_bins", value="_FUNC_(number weight, const int num_of_bins[, const boolean auto_shrink = false]) - Return quantiles representing bins: array<double>")
public final class BuildBinsUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] OIs = info.getParameterObjectInspectors();
        if (OIs.length != 2 && OIs.length != 3) {
            throw new UDFArgumentLengthException("Specify two or three arguments.");
        }
        if (!HiveUtils.isNumberOI(OIs[0])) {
            throw new UDFArgumentTypeException(0, "Only number type argument is acceptable but " + OIs[0].getTypeName() + " was passed as `weight`");
        }
        if (!HiveUtils.isIntegerOI(OIs[1])) {
            throw new UDFArgumentTypeException(1, "Only int type argument is acceptable but " + OIs[1].getTypeName() + " was passed as `num_of_bins`");
        }
        if (OIs.length == 3 && !HiveUtils.isBooleanOI(OIs[2])) {
            throw new UDFArgumentTypeException(2, "Only boolean type argument is acceptable but " + OIs[2].getTypeName() + " was passed as `auto_shrink`");
        }
        return new BuildBinsUDAFEvaluator();
    }

    private static class BuildBinsUDAFEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector weightOI;
        private StructObjectInspector structOI;
        private StructField autoShrinkField;
        private StructField histogramField;
        private StructField quantilesField;
        private BooleanObjectInspector autoShrinkOI;
        private StandardListObjectInspector histogramOI;
        private DoubleObjectInspector histogramElOI;
        private StandardListObjectInspector quantilesOI;
        private DoubleObjectInspector quantileOI;
        private int nBGBins = 10000;
        private int nBins;
        private boolean autoShrink = false;
        private double[] quantiles;

        private BuildBinsUDAFEvaluator() {
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] OIs) throws HiveException {
            super.init(mode, OIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.weightOI = HiveUtils.asDoubleCompatibleOI(OIs[0]);
                this.nBins = HiveUtils.getConstInt(OIs[1]);
                if (OIs.length == 3) {
                    this.autoShrink = HiveUtils.getConstBoolean(OIs[2]);
                }
                if (this.nBins < 2) {
                    throw new UDFArgumentException("Only greater than or equal to 2 is accepted but " + this.nBins + " was passed as `num_of_bins`.");
                }
                this.quantiles = this.getQuantiles();
            } else {
                this.structOI = (StructObjectInspector)OIs[0];
                this.autoShrinkField = this.structOI.getStructFieldRef("autoShrink");
                this.histogramField = this.structOI.getStructFieldRef("histogram");
                this.quantilesField = this.structOI.getStructFieldRef("quantiles");
                this.autoShrinkOI = (WritableBooleanObjectInspector)this.autoShrinkField.getFieldObjectInspector();
                this.histogramOI = (StandardListObjectInspector)this.histogramField.getFieldObjectInspector();
                this.quantilesOI = (StandardListObjectInspector)this.quantilesField.getFieldObjectInspector();
                this.histogramElOI = (WritableDoubleObjectInspector)this.histogramOI.getListElementObjectInspector();
                this.quantileOI = (WritableDoubleObjectInspector)this.quantilesOI.getListElementObjectInspector();
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<Object> fieldOIs = new ArrayList<Object>();
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
                fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("autoShrink", "histogram", "quantiles"), fieldOIs);
            }
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        }

        private double[] getQuantiles() throws HiveException {
            int nQuantiles = this.nBins - 1;
            double[] result = new double[nQuantiles];
            for (int i = 0; i < nQuantiles; ++i) {
                result[i] = (double)(i + 1) / (double)(nQuantiles + 1);
            }
            return result;
        }

        public GenericUDAFEvaluator.AbstractAggregationBuffer getNewAggregationBuffer() throws HiveException {
            BuildBinsAggregationBuffer myAgg = new BuildBinsAggregationBuffer();
            myAgg.histogram = new NumericHistogram();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myAgg);
            return myAgg;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BuildBinsAggregationBuffer myAgg = (BuildBinsAggregationBuffer)agg;
            myAgg.autoShrink = this.autoShrink;
            myAgg.histogram.reset();
            myAgg.histogram.allocate(this.nBGBins);
            myAgg.quantiles = this.quantiles;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Preconditions.checkArgument(parameters.length == 2 || parameters.length == 3);
            if (parameters[0] == null || parameters[1] == null) {
                return;
            }
            BuildBinsAggregationBuffer myAgg = (BuildBinsAggregationBuffer)agg;
            myAgg.histogram.add(PrimitiveObjectInspectorUtils.getDouble((Object)parameters[0], (PrimitiveObjectInspector)this.weightOI));
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object other) throws HiveException {
            if (other == null) {
                return;
            }
            BuildBinsAggregationBuffer myAgg = (BuildBinsAggregationBuffer)agg;
            myAgg.autoShrink = this.autoShrinkOI.get(this.structOI.getStructFieldData(other, this.autoShrinkField));
            List histogram = ((LazyBinaryArray)this.structOI.getStructFieldData(other, this.histogramField)).getList();
            myAgg.histogram.merge(histogram, this.histogramElOI);
            double[] quantiles = HiveUtils.asDoubleArray(this.structOI.getStructFieldData(other, this.quantilesField), (ListObjectInspector)this.quantilesOI, (PrimitiveObjectInspector)this.quantileOI);
            if (quantiles != null && quantiles.length > 0) {
                myAgg.quantiles = quantiles;
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BuildBinsAggregationBuffer myAgg = (BuildBinsAggregationBuffer)agg;
            Object[] partialResult = new Object[]{new BooleanWritable(myAgg.autoShrink), myAgg.histogram.serialize(), myAgg.quantiles != null ? WritableUtils.toWritableList(myAgg.quantiles) : Collections.singletonList(new DoubleWritable(0.0))};
            return partialResult;
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BuildBinsAggregationBuffer myAgg = (BuildBinsAggregationBuffer)agg;
            if (myAgg.histogram.getUsedBins() < 1) {
                return null;
            }
            Preconditions.checkNotNull(myAgg.quantiles);
            ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
            double prev = Double.NEGATIVE_INFINITY;
            result.add(new DoubleWritable(Double.NEGATIVE_INFINITY));
            for (int i = 0; i < myAgg.quantiles.length; ++i) {
                double val = myAgg.histogram.quantile(myAgg.quantiles[i]);
                if (prev == val) {
                    if (myAgg.autoShrink) continue;
                    throw new HiveException("Quantiles were repeated even though `auto_shrink` is false. Reduce `num_of_bins` or enable `auto_shrink`.");
                }
                result.add(new DoubleWritable(val));
                prev = val;
            }
            result.add(new DoubleWritable(Double.POSITIVE_INFINITY));
            return result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static final class BuildBinsAggregationBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            boolean autoShrink;
            NumericHistogram histogram;
            double[] quantiles;

            BuildBinsAggregationBuffer() {
            }

            public int estimate() {
                return (this.histogram != null ? this.histogram.lengthFor() : 0) + 20 + 8 * (this.quantiles != null ? this.quantiles.length : 0) + 4;
            }
        }
    }
}

