/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.binning;

import hivemall.annotations.VisibleForTesting;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="feature_binning", value="_FUNC_(array<features::string> features, map<string, array<number>> quantiles_map) - returns a binned feature vector as an array<features::string>\n_FUNC_(number weight, array<number> quantiles) - returns bin ID as int", extended="WITH extracted as (\n  select \n    extract_feature(feature) as index,\n    extract_weight(feature) as value\n  from\n    input l\n    LATERAL VIEW explode(features) r as feature\n),\nmapping as (\n  select\n    index, \n    build_bins(value, 5, true) as quantiles -- 5 bins with auto bin shrinking\n  from\n    extracted\n  group by\n    index\n),\nbins as (\n   select \n    to_map(index, quantiles) as quantiles \n   from\n    mapping\n)\nselect\n  l.features as original,\n  feature_binning(l.features, r.quantiles) as features\nfrom\n  input l\n  cross join bins r\n\n> [\"name#Jacob\",\"gender#Male\",\"age:20.0\"] [\"name#Jacob\",\"gender#Male\",\"age:2\"]\n> [\"name#Isabella\",\"gender#Female\",\"age:20.0\"]    [\"name#Isabella\",\"gender#Female\",\"age:2\"]")
@UDFType(deterministic=true, stateful=false)
public final class FeatureBinningUDF
extends GenericUDF {
    private boolean multiple = true;
    private ListObjectInspector featuresOI;
    private StringObjectInspector featureOI;
    private MapObjectInspector quantilesMapOI;
    private StringObjectInspector keyOI;
    private ListObjectInspector quantilesOI;
    private PrimitiveObjectInspector quantileOI;
    private PrimitiveObjectInspector weightOI;
    private transient Map<String, double[]> quantilesMap;
    private transient double[] quantilesArray;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentLengthException("Specify two arguments :" + argOIs.length);
        }
        if (HiveUtils.isListOI(argOIs[0]) && HiveUtils.isMapOI(argOIs[1])) {
            if (!HiveUtils.isStringOI(((ListObjectInspector)argOIs[0]).getListElementObjectInspector())) {
                throw new UDFArgumentTypeException(0, "Only array<string> type argument can be accepted but " + argOIs[0].getTypeName() + " was passed as `features`");
            }
            this.featuresOI = HiveUtils.asListOI(argOIs[0]);
            this.featureOI = HiveUtils.asStringOI(this.featuresOI.getListElementObjectInspector());
            this.quantilesMapOI = HiveUtils.asMapOI(argOIs[1]);
            if (!(HiveUtils.isStringOI(this.quantilesMapOI.getMapKeyObjectInspector()) && HiveUtils.isListOI(this.quantilesMapOI.getMapValueObjectInspector()) && HiveUtils.isNumberOI(((ListObjectInspector)this.quantilesMapOI.getMapValueObjectInspector()).getListElementObjectInspector()))) {
                throw new UDFArgumentTypeException(1, "Only map<string, array<number>> type argument can be accepted but " + argOIs[1].getTypeName() + " was passed as `quantiles_map`");
            }
            this.keyOI = HiveUtils.asStringOI(this.quantilesMapOI.getMapKeyObjectInspector());
            this.quantilesOI = HiveUtils.asListOI(this.quantilesMapOI.getMapValueObjectInspector());
            this.quantileOI = HiveUtils.asDoubleCompatibleOI(this.quantilesOI.getListElementObjectInspector());
            this.multiple = true;
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        if (HiveUtils.isPrimitiveOI(argOIs[0]) && HiveUtils.isListOI(argOIs[1])) {
            this.weightOI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
            this.quantilesOI = HiveUtils.asListOI(argOIs[1]);
            if (!HiveUtils.isNumberOI(this.quantilesOI.getListElementObjectInspector())) {
                throw new UDFArgumentTypeException(1, "Only array<number> type argument can be accepted but " + argOIs[1].getTypeName() + " was passed as `quantiles`");
            }
            this.quantileOI = HiveUtils.asDoubleCompatibleOI(this.quantilesOI.getListElementObjectInspector());
            this.multiple = false;
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        throw new UDFArgumentTypeException(0, "Only <array<features::string>, map<string, array<number>>> or <number, array<number>> type arguments can be accepted but <" + argOIs[0].getTypeName() + ", " + argOIs[1].getTypeName() + "> was passed.");
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        Object arg1 = args[1].get();
        if (arg1 == null) {
            throw new UDFArgumentException("The second argument (i.e., quantiles) MUST be non-null value");
        }
        if (this.multiple) {
            if (this.quantilesMap == null) {
                Map map = this.quantilesMapOI.getMap(arg1);
                this.quantilesMap = new HashMap<String, double[]>(map.size() * 2);
                for (Map.Entry e : map.entrySet()) {
                    String k = this.keyOI.getPrimitiveJavaObject(e.getKey());
                    double[] v = HiveUtils.asDoubleArray(e.getValue(), this.quantilesOI, this.quantileOI);
                    this.quantilesMap.put(k, v);
                }
            }
            List features = this.featuresOI.getList(arg0);
            ArrayList<Text> result = new ArrayList<Text>();
            for (Object f : features) {
                String entry = this.featureOI.getPrimitiveJavaObject(f);
                int pos = entry.indexOf(58);
                if (pos < 0) {
                    result.add(new Text(entry));
                    continue;
                }
                String k = entry.substring(0, pos);
                String v = entry.substring(pos + 1);
                double[] bins = this.quantilesMap.get(k);
                if (bins != null) {
                    v = String.valueOf(FeatureBinningUDF.findBin(bins, Double.parseDouble(v)));
                }
                result.add(new Text(k + ':' + v));
            }
            return result;
        }
        if (this.quantilesArray == null) {
            this.quantilesArray = HiveUtils.asDoubleArray(arg1, this.quantilesOI, this.quantileOI);
        }
        return new IntWritable(FeatureBinningUDF.findBin(this.quantilesArray, PrimitiveObjectInspectorUtils.getDouble((Object)arg0, (PrimitiveObjectInspector)this.weightOI)));
    }

    @VisibleForTesting
    static int findBin(@Nonnull double[] quantiles, double value) throws HiveException {
        if (quantiles.length < 3) {
            throw new HiveException("Length of `quantiles` should be greater than or equal to three but " + quantiles.length + ".");
        }
        int pos = Arrays.binarySearch(quantiles, value);
        return pos < 0 ? ~pos - 1 : (pos == 0 ? 0 : pos - 1);
    }

    public String getDisplayString(String[] children) {
        return "feature_binning(" + StringUtils.join(children, ',') + ')';
    }
}

