/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.conv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.io.FloatWritable;

@Description(name="conv2dense", value="_FUNC_(int feature, float weight, int nDims) - Return a dense model in array<float>")
public class ConvertToDenseModelUDAF
extends UDAF {

    public static class Evaluator
    implements UDAFEvaluator {
        private List<FloatWritable> partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(int feature, float weight, int nDims) {
            if (this.partial == null) {
                FloatWritable[] array = new FloatWritable[nDims];
                this.partial = Arrays.asList(array);
            }
            this.partial.set(feature, new FloatWritable(weight));
            return true;
        }

        public List<FloatWritable> terminatePartial() {
            return this.partial;
        }

        public boolean merge(List<FloatWritable> other) {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new ArrayList<FloatWritable>(other);
                return true;
            }
            int nDims = other.size();
            for (int i = 0; i < nDims; ++i) {
                FloatWritable x = other.set(i, null);
                if (x == null) continue;
                this.partial.set(i, x);
            }
            return true;
        }

        public List<FloatWritable> terminate() {
            if (this.partial == null) {
                return null;
            }
            return this.partial;
        }
    }
}

