/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.conv;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Identifier;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="quantify", value="_FUNC_(boolean output, col1, col2, ...) - Returns an identified features")
public final class QuantifyColumnsUDTF
extends GenericUDTF {
    private BooleanObjectInspector boolOI;
    private Identifier<String>[] identifiers;
    private Object[] forwardObjs;
    private IntWritable[] forwardIntObjs;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int size = argOIs.length;
        if (size < 2) {
            throw new UDFArgumentException("quantified_features takes at least two arguments: " + size);
        }
        this.boolOI = HiveUtils.asBooleanOI(argOIs[0]);
        int outputSize = size - 1;
        this.forwardObjs = new Object[outputSize];
        this.forwardIntObjs = new IntWritable[outputSize];
        this.identifiers = new Identifier[outputSize];
        ArrayList<String> fieldNames = new ArrayList<String>(outputSize);
        ArrayList<Object> fieldOIs = new ArrayList<Object>(outputSize);
        for (int i = 0; i < outputSize; ++i) {
            fieldNames.add("c" + i);
            ObjectInspector argOI = argOIs[i + 1];
            if (HiveUtils.isNumberOI(argOI)) {
                fieldOIs.add(argOI);
                continue;
            }
            this.identifiers[i] = new Identifier();
            this.forwardIntObjs[i] = new IntWritable(-1);
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        boolean outputRow = this.boolOI.get(args[0]);
        if (outputRow) {
            Object[] forwardObjs = this.forwardObjs;
            int outputSize = args.length - 1;
            for (int i = 0; i < outputSize; ++i) {
                Object arg = args[i + 1];
                Identifier<String> identifier = this.identifiers[i];
                if (identifier == null) {
                    forwardObjs[i] = arg;
                    continue;
                }
                if (arg == null) {
                    forwardObjs[i] = null;
                    continue;
                }
                String k = arg.toString();
                int id = identifier.valueOf(k);
                IntWritable o = this.forwardIntObjs[i];
                o.set(id);
                forwardObjs[i] = o;
            }
            this.forward(forwardObjs);
        } else {
            int outputSize = args.length - 1;
            for (int i = 0; i < outputSize; ++i) {
                Object arg;
                Identifier<String> identifier = this.identifiers[i];
                if (identifier == null || (arg = args[i + 1]) == null) continue;
                String k = arg.toString();
                identifier.valueOf(k);
            }
        }
    }

    public void close() throws HiveException {
        this.boolOI = null;
        this.identifiers = null;
        this.forwardObjs = null;
        this.forwardIntObjs = null;
    }
}

