/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.conv;

import hivemall.model.FeatureValue;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;

@Description(name="to_dense_features", value="_FUNC_(array<string> feature_vector, int dimensions) - Returns a dense feature in array<float>")
@UDFType(deterministic=true, stateful=false)
public final class ToDenseFeaturesUDF
extends UDF {
    @Nullable
    public List<Float> evaluate(@Nullable List<String> features) throws HiveException {
        if (features == null) {
            return null;
        }
        int size = features.size();
        return this.evaluate(features, size);
    }

    @Nullable
    public List<Float> evaluate(@Nullable List<String> features, @Nonnegative int dimensions) throws HiveException {
        if (features == null) {
            return null;
        }
        FeatureValue probe = new FeatureValue();
        Float[] fv = new Float[dimensions + 1];
        for (String ft : features) {
            FeatureValue.parseFeatureAsString(ft, probe);
            String f = (String)probe.getFeature();
            int i = Integer.parseInt(f);
            if (i > dimensions) {
                throw new HiveException("IndexOutOfBounds: " + i);
            }
            float v = probe.getValueAsFloat();
            fv[i] = new Float(v);
        }
        return Arrays.asList(fv);
    }
}

