/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.conv;

import hivemall.UDFWithOptions;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hashing.MurmurHash3;
import hivemall.utils.lang.NumberUtils;
import hivemall.utils.lang.Primitives;
import hivemall.utils.lang.StringUtils;
import hivemall.utils.struct.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="to_libsvm_format", value="_FUNC_(array<string> feautres [, double/integer target, const string options]) - Returns a string representation of libsvm", extended="Usage:\n select to_libsvm_format(array('apple:3.4','orange:2.1'))\n > 6284535:3.4 8104713:2.1\n select to_libsvm_format(array('apple:3.4','orange:2.1'), '-features 10')\n > 3:2.1 7:3.4\n select to_libsvm_format(array('7:3.4','3:2.1'), 5.0)\n > 5.0 3:2.1 7:3.4")
@UDFType(deterministic=true, stateful=false)
public final class ToLibSVMFormatUDF
extends UDFWithOptions {
    private ListObjectInspector _featuresOI;
    @Nullable
    private PrimitiveObjectInspector _targetOI = null;
    private int _numFeatures = 0x1000000;
    private StringBuilder _buf;
    private static final Comparator<Pair<Integer, Double>> comparator = new Comparator<Pair<Integer, Double>>(){

        @Override
        public int compare(Pair<Integer, Double> l, Pair<Integer, Double> r) {
            return ((Integer)l.getKey()).compareTo((Integer)r.getKey());
        }
    };

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("features", "num_features", true, "The number of features [default: 16777217 (2^24)]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(@Nonnull String optionValue) throws UDFArgumentException {
        CommandLine cl = this.parseOptions(optionValue);
        this._numFeatures = Primitives.parseInt(cl.getOptionValue("num_features"), 0x1000000);
        ToLibSVMFormatUDF.assumeTrue(this._numFeatures > 0, "num_features must be greater than 0: " + this._numFeatures);
        return cl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        ToLibSVMFormatUDF.assumeTrue(argOIs.length >= 1 || argOIs.length <= 3, "to_libsvm_format UDF takes 1~3 arguments");
        this._featuresOI = HiveUtils.asListOI(argOIs[0]);
        if (argOIs.length == 2) {
            ObjectInspector argOI1 = argOIs[1];
            if (HiveUtils.isNumberOI(argOI1)) {
                this._targetOI = HiveUtils.asNumberOI(argOI1);
            } else {
                if (!HiveUtils.isConstString(argOI1)) throw new UDFArgumentException("Unexpected argument type for 2nd argument: " + argOI1.getTypeName());
                String opts = HiveUtils.getConstString(argOI1);
                this.processOptions(opts);
            }
        } else if (argOIs.length == 3) {
            this._targetOI = HiveUtils.asNumberOI(argOIs[1]);
            String opts = HiveUtils.getConstString(argOIs[2]);
            this.processOptions(opts);
        }
        this._buf = new StringBuilder();
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    @Nullable
    public String evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        Pair fv;
        int i;
        StringBuilder buf = this._buf;
        StringUtils.clear(buf);
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return null;
        }
        int featureSize = this._featuresOI.getListLength(arg0);
        ArrayList<Pair> features = new ArrayList<Pair>(featureSize);
        for (i = 0; i < featureSize; ++i) {
            Object e = this._featuresOI.getListElement(arg0, i);
            if (e == null) continue;
            fv = ToLibSVMFormatUDF.parse(e.toString(), this._numFeatures);
            features.add(fv);
        }
        Collections.sort(features, comparator);
        if (this._targetOI != null) {
            Object arg1 = args[1].get();
            if (arg1 == null) {
                throw new HiveException("Detected NULL for the 2nd argument");
            }
            if (HiveUtils.isIntegerOI((ObjectInspector)this._targetOI)) {
                int label = HiveUtils.getInt(arg1, this._targetOI);
                buf.append(label);
            } else {
                double label = HiveUtils.getDouble(arg1, this._targetOI);
                buf.append(label);
            }
            buf.append(' ');
        }
        int size = features.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            fv = (Pair)features.get(i);
            buf.append((Integer)fv.getKey());
            buf.append(':');
            buf.append((Double)fv.getValue());
        }
        return buf.toString();
    }

    @Nonnull
    public static Pair<Integer, Double> parse(@Nonnull String fv, @Nonnegative int numFeatures) throws UDFArgumentException {
        double d;
        int headPos = fv.indexOf(58);
        if (headPos == -1) {
            if (NumberUtils.isDigits(fv)) {
                int f;
                try {
                    f = Integer.parseInt(fv);
                }
                catch (NumberFormatException e) {
                    throw new UDFArgumentException("Invalid feature value: " + fv);
                }
                return new Pair<Integer, Double>(f, 1.0);
            }
            return new Pair<Integer, Double>(ToLibSVMFormatUDF.mhash(fv, numFeatures), 1.0);
        }
        int tailPos = fv.lastIndexOf(58);
        if (headPos != tailPos) {
            throw new UDFArgumentException("Unsupported feature format: " + fv);
        }
        String f = fv.substring(0, headPos);
        String v = fv.substring(headPos + 1);
        try {
            d = Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            throw new UDFArgumentException("Invalid feature value: " + fv);
        }
        if (NumberUtils.isDigits(f)) {
            int i;
            try {
                i = Integer.parseInt(f);
            }
            catch (NumberFormatException e) {
                throw new UDFArgumentException("Invalid feature value: " + fv);
            }
            return new Pair<Integer, Double>(i, d);
        }
        return new Pair<Integer, Double>(ToLibSVMFormatUDF.mhash(f, numFeatures), d);
    }

    private static int mhash(@Nonnull String word, int numFeatures) {
        int r = MurmurHash3.murmurhash3_x86_32(word, 0, word.length(), -1756908916) % numFeatures;
        if (r < 0) {
            r += numFeatures;
        }
        return r + 1;
    }

    public String getDisplayString(String[] args) {
        return "to_libsvm_format( " + StringUtils.join(args, ',') + " )";
    }
}

