/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.conv;

import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;

@Description(name="to_sparse_features", value="_FUNC_(array<float> feature_vector) - Returns a sparse feature in array<string>")
@UDFType(deterministic=true, stateful=false)
public final class ToSparseFeaturesUDF
extends UDF {
    @Nullable
    public List<String> evaluate(@Nullable List<FloatWritable> features) {
        return this.evaluate(features, null);
    }

    @Nullable
    public List<String> evaluate(@Nullable List<FloatWritable> features, @Nullable String biasName) {
        if (features == null) {
            return null;
        }
        int size = features.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        StringBuilder buf = new StringBuilder(64);
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            FloatWritable o = features.get(i);
            if (o == null) continue;
            float v = o.get();
            String s = biasName != null ? buf.append(biasName).append(':').append(v).toString() : buf.append(i).append(':').append(v).toString();
            list.add(s);
            StringUtils.clear(buf);
        }
        return list;
    }
}

