/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.hashing;

import hivemall.utils.hashing.MurmurHash3;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="mhash", value="_FUNC_(string word) returns a murmurhash3 INT value starting from 1")
@UDFType(deterministic=true, stateful=false)
public final class MurmurHash3UDF
extends UDF {
    @Nullable
    public IntWritable evaluate(@Nullable String word) throws UDFArgumentException {
        return this.evaluate(word, 0x1000000);
    }

    @Nullable
    public IntWritable evaluate(@Nullable String word, int numFeatures) throws UDFArgumentException {
        if (word == null) {
            return null;
        }
        int h = MurmurHash3UDF.mhash(word, numFeatures);
        return new IntWritable(h);
    }

    @Nullable
    public IntWritable evaluate(@Nullable List<String> words) throws UDFArgumentException {
        return this.evaluate(words, 0x1000000);
    }

    @Nullable
    public IntWritable evaluate(@Nullable List<String> words, int numFeatures) throws UDFArgumentException {
        if (words == null) {
            return null;
        }
        int size = words.size();
        if (size == 0) {
            return new IntWritable(1);
        }
        StringBuilder b = new StringBuilder();
        b.append(words.get(0));
        for (int i = 1; i < size; ++i) {
            b.append('\t');
            String v = words.get(i);
            b.append(v);
        }
        String s = b.toString();
        return this.evaluate(s, numFeatures);
    }

    public static int mhash(@Nonnull String word) {
        return MurmurHash3UDF.mhash(word, 0x1000000);
    }

    public static int mhash(@Nonnull String word, int numFeatures) {
        int r = MurmurHash3.murmurhash3_x86_32(word, 0, word.length(), -1756908916) % numFeatures;
        if (r < 0) {
            r += numFeatures;
        }
        return r + 1;
    }
}

