/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.pairing;

import hivemall.UDTFWithOptions;
import hivemall.factorization.fm.Feature;
import hivemall.model.FeatureValue;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hashing.HashFunction;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.lang.Primitives;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

@Description(name="feature_pairs", value="_FUNC_(feature_vector in array<string>, [, const string options]) - Returns a relation <string i, string j, double xi, double xj>")
public final class FeaturePairsUDTF
extends UDTFWithOptions {
    private Type _type;
    private RowProcessor _proc;
    private int _numFields;
    private int _numFeatures;
    private boolean _l2norm;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("kpa", false, "Generate feature pairs for Kernel-Expansion Passive Aggressive [default:false]");
        opts.addOption("ffm", false, "Generate feature pairs for Field-aware Factorization Machines [default:false]");
        opts.addOption("p", "num_features", true, "The size of feature dimensions [default: -1]");
        opts.addOption("feature_hashing", true, "The number of bits for feature hashing in range [18,31]. [default: -1] No feature hashing for -1.");
        opts.addOption("num_fields", true, "The number of fields [default: 256]");
        opts.addOption("no_norm", "disable_norm", false, "Disable instance-wise L2 normalization");
        return opts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = null;
        if (argOIs.length != 2) throw new UDFArgumentException("MUST provide -kpa or -ffm in the option");
        String args = HiveUtils.getConstString(argOIs[1]);
        cl = this.parseOptions(args);
        Preconditions.checkArgument(cl.getOptions().length <= 3, UDFArgumentException.class, (Object)("Too many options were specified: " + cl.getArgList()));
        if (cl.hasOption("kpa")) {
            this._type = Type.kpa;
            return cl;
        } else {
            int featureBits;
            if (!cl.hasOption("ffm")) throw new UDFArgumentException("Unsupported option: " + cl.getArgList().get(0));
            this._type = Type.ffm;
            this._numFeatures = Primitives.parseInt(cl.getOptionValue("num_features"), -1);
            if (this._numFeatures == -1 && (featureBits = Primitives.parseInt(cl.getOptionValue("feature_hashing"), -1)) != -1) {
                if (featureBits < 18 || featureBits > 31) {
                    throw new UDFArgumentException("-feature_hashing MUST be in range [18,31]: " + featureBits);
                }
                this._numFeatures = 1 << featureBits;
            }
            this._numFields = Primitives.parseInt(cl.getOptionValue("num_fields"), 256);
            if (this._numFields <= 1) {
                throw new UDFArgumentException("-num_fields MUST be greater than 1: " + this._numFields);
            }
            this._l2norm = !cl.hasOption("disable_norm");
        }
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1 && argOIs.length != 2) {
            throw new UDFArgumentException("_FUNC_ takes 1 or 2 arguments");
        }
        this.processOptions(argOIs);
        ListObjectInspector fvOI = HiveUtils.asListOI(argOIs[0]);
        HiveUtils.validateFeatureOI(fvOI.getListElementObjectInspector());
        ArrayList<String> fieldNames = new ArrayList<String>(4);
        ArrayList<Object> fieldOIs = new ArrayList<Object>(4);
        switch (this._type) {
            case kpa: {
                this._proc = new KPAProcessor(fvOI);
                fieldNames.add("h");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                fieldNames.add("hk");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                fieldNames.add("xh");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                fieldNames.add("xk");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                break;
            }
            case ffm: {
                this._proc = new FFMProcessor(fvOI);
                fieldNames.add("i");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                fieldNames.add("j");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                fieldNames.add("xi");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                fieldNames.add("xj");
                fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException("Illegal condition: " + (Object)((Object)this._type));
            }
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        Object arg0 = args[0];
        if (arg0 == null) {
            return;
        }
        this._proc.process(arg0);
    }

    public void close() throws HiveException {
        this._proc = null;
    }

    final class FFMProcessor
    extends RowProcessor {
        @Nonnull
        private final IntWritable f0;
        @Nonnull
        private final IntWritable f1;
        @Nonnull
        private final DoubleWritable f2;
        @Nonnull
        private final DoubleWritable f3;
        @Nonnull
        private final Writable[] forward;
        @Nullable
        private transient Feature[] _features;

        FFMProcessor(ListObjectInspector fvOI) {
            super(fvOI);
            this.f0 = new IntWritable();
            this.f1 = new IntWritable();
            this.f2 = new DoubleWritable();
            this.f3 = new DoubleWritable();
            this.forward = new Writable[]{this.f0, null, null, null};
            this._features = null;
        }

        @Override
        void process(@Nonnull Object arg) throws HiveException {
            int size = this.fvOI.getListLength(arg);
            if (size == 0) {
                return;
            }
            this._features = Feature.parseFFMFeatures(arg, this.fvOI, this._features, FeaturePairsUDTF.this._numFeatures, FeaturePairsUDTF.this._numFields);
            if (FeaturePairsUDTF.this._l2norm) {
                Feature.l2normalize(this._features);
            }
            this.f0.set(0);
            this.forward[1] = null;
            this.forward[2] = null;
            this.forward[3] = null;
            FeaturePairsUDTF.this.forward(this.forward);
            this.forward[2] = this.f2;
            Feature[] features = this._features;
            int len = features.length;
            for (int i = 0; i < len; ++i) {
                Feature ei = features[i];
                this.f0.set(Feature.toIntFeature(ei));
                this.forward[1] = null;
                this.f2.set(ei.getValue());
                this.forward[3] = null;
                FeaturePairsUDTF.this.forward(this.forward);
                this.forward[1] = this.f1;
                this.forward[3] = this.f3;
                short iField = ei.getField();
                for (int j = i + 1; j < len; ++j) {
                    Feature ej = features[j];
                    double xj = ej.getValue();
                    short jField = ej.getField();
                    int ifj = Feature.toIntFeature(ei, jField, FeaturePairsUDTF.this._numFields);
                    int jfi = Feature.toIntFeature(ej, iField, FeaturePairsUDTF.this._numFields);
                    this.f0.set(ifj);
                    this.f1.set(jfi);
                    this.f3.set(xj);
                    FeaturePairsUDTF.this.forward(this.forward);
                }
            }
        }
    }

    final class KPAProcessor
    extends RowProcessor {
        @Nonnull
        private final IntWritable f0;
        @Nonnull
        private final IntWritable f1;
        @Nonnull
        private final DoubleWritable f2;
        @Nonnull
        private final DoubleWritable f3;
        @Nonnull
        private final Writable[] forward;

        KPAProcessor(ListObjectInspector fvOI) {
            super(fvOI);
            this.f0 = new IntWritable();
            this.f1 = new IntWritable();
            this.f2 = new DoubleWritable();
            this.f3 = new DoubleWritable();
            this.forward = new Writable[]{this.f0, null, null, null};
        }

        @Override
        void process(@Nonnull Object arg) throws HiveException {
            int i;
            int size = this.fvOI.getListLength(arg);
            if (size == 0) {
                return;
            }
            ArrayList<FeatureValue> features = new ArrayList<FeatureValue>(size);
            for (i = 0; i < size; ++i) {
                Object f = this.fvOI.getListElement(arg, i);
                if (f == null) continue;
                FeatureValue fv = FeatureValue.parse(f, true);
                features.add(fv);
            }
            this.forward[0] = this.f0;
            this.f0.set(0);
            this.forward[1] = null;
            this.forward[2] = null;
            this.forward[3] = null;
            FeaturePairsUDTF.this.forward(this.forward);
            this.forward[2] = this.f2;
            int len = features.size();
            for (i = 0; i < len; ++i) {
                FeatureValue xi = (FeatureValue)features.get(i);
                int h = xi.getFeatureAsInt();
                double xh = xi.getValue();
                this.forward[0] = this.f0;
                this.f0.set(h);
                this.forward[1] = null;
                this.f2.set(xh);
                this.forward[3] = null;
                FeaturePairsUDTF.this.forward(this.forward);
                this.forward[0] = null;
                this.forward[1] = this.f1;
                this.forward[3] = this.f3;
                for (int j = i + 1; j < len; ++j) {
                    FeatureValue xj = (FeatureValue)features.get(j);
                    int k = xj.getFeatureAsInt();
                    int hk = HashFunction.hash(h, k, true);
                    double xk = xj.getValue();
                    this.f1.set(hk);
                    this.f3.set(xk);
                    FeaturePairsUDTF.this.forward(this.forward);
                }
            }
        }
    }

    abstract class RowProcessor {
        @Nonnull
        protected final ListObjectInspector fvOI;

        RowProcessor(ListObjectInspector fvOI) {
            this.fvOI = fvOI;
        }

        abstract void process(@Nonnull Object var1) throws HiveException;
    }

    public static enum Type {
        kpa,
        ffm;

    }
}

