/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.pairing;

import hivemall.model.FeatureValue;
import hivemall.utils.HivemallUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="polynomial_features", value="_FUNC_(feature_vector in array<string>) - Returns a feature vectorhaving polynomial feature space")
@UDFType(deterministic=true, stateful=false)
public final class PolynomialFeaturesUDF
extends UDF {
    public List<Text> evaluate(List<Text> ftvec, int degree) throws HiveException {
        return this.evaluate(ftvec, degree, false, true);
    }

    public List<Text> evaluate(List<Text> ftvec, int degree, boolean interactionOnly) throws HiveException {
        return this.evaluate(ftvec, degree, interactionOnly, true);
    }

    public List<Text> evaluate(List<Text> ftvec, int degree, boolean interactionOnly, boolean truncate) throws HiveException {
        if (ftvec == null) {
            return null;
        }
        if (degree < 2) {
            throw new HiveException("degree must be greater than or equals to 2: " + degree);
        }
        int origSize = ftvec.size();
        if (origSize == 0) {
            return Collections.emptyList();
        }
        List<FeatureValue> srcVec = HivemallUtils.parseTextFeaturesAsString(ftvec);
        ArrayList<Text> dstVec = new ArrayList<Text>(origSize * degree * 2);
        for (int i = 0; i < origSize; ++i) {
            Text t = ftvec.get(i);
            if (t == null) continue;
            dstVec.add(t);
            FeatureValue fv = srcVec.get(i);
            float v = fv.getValueAsFloat();
            if (truncate && (v == 0.0f || v == 1.0f)) continue;
            String f = (String)fv.getFeature();
            PolynomialFeaturesUDF.addPolynomialFeature(f, v, 2, degree, srcVec, i, dstVec, interactionOnly, truncate);
        }
        return dstVec;
    }

    private static void addPolynomialFeature(String baseF, float baseV, int currentDegree, int degree, List<FeatureValue> srcVec, int currentSrcPos, List<Text> dstVec, boolean interactionOnly, boolean truncate) {
        assert (currentDegree <= degree) : "currentDegree: " + currentDegree + ", degree: " + degree;
        int lastSrcIndex = srcVec.size() - 1;
        for (int i = currentSrcPos; i <= lastSrcIndex; ++i) {
            if (interactionOnly && i == currentSrcPos) continue;
            FeatureValue ftvec = srcVec.get(i);
            float v = ftvec.getValueAsFloat();
            if (truncate && (v == 0.0f || v == 1.0f)) continue;
            String f = (String)ftvec.getFeature();
            String f2 = baseF + '^' + f;
            float v2 = baseV * v;
            String fv2 = f2 + ':' + v2;
            dstVec.add(new Text(fv2));
            if (currentDegree >= degree || i > lastSrcIndex) continue;
            PolynomialFeaturesUDF.addPolynomialFeature(f2, v2, currentDegree + 1, degree, srcVec, i, dstVec, interactionOnly, truncate);
        }
    }
}

