/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.pairing;

import hivemall.model.FeatureValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="powered_features", value="_FUNC_(feature_vector in array<string>, int degree [, boolean truncate]) - Returns a feature vector having a powered feature space")
@UDFType(deterministic=true, stateful=false)
public final class PoweredFeaturesUDF
extends UDF {
    public List<Text> evaluate(List<Text> ftvec, int degree) throws HiveException {
        return this.evaluate(ftvec, degree, true);
    }

    public List<Text> evaluate(List<Text> ftvec, int degree, boolean truncate) throws HiveException {
        if (ftvec == null) {
            return null;
        }
        if (degree < 2) {
            throw new HiveException("degree must be greater than or equals to 2: " + degree);
        }
        int origSize = ftvec.size();
        if (origSize == 0) {
            return Collections.emptyList();
        }
        FeatureValue probe = new FeatureValue();
        ArrayList<Text> dstVec = new ArrayList<Text>(origSize * degree);
        for (int i = 0; i < origSize; ++i) {
            Text t = ftvec.get(i);
            if (t == null) continue;
            dstVec.add(t);
            FeatureValue.parseFeatureAsString(t, probe);
            float v = probe.getValueAsFloat();
            if (truncate && (v == 0.0f || v == 1.0f)) continue;
            String f = (String)probe.getFeature();
            float baseV = v;
            for (int d = 2; d <= degree; ++d) {
                String f2 = f + '^' + d;
                Text t2 = new Text(f2 + ':' + (baseV *= v));
                dstVec.add(t2);
            }
        }
        return dstVec;
    }
}

