/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.ranking;

import hivemall.UDTFWithOptions;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.BitUtils;
import hivemall.utils.lang.Primitives;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="item_pairs_sampling", value="_FUNC_(array<int|long> pos_items, const int max_item_id [, const string options])- Returns a relation consists of <int pos_item_id, int neg_item_id>")
public final class ItemPairsSamplingUDTF
extends UDTFWithOptions {
    private ListObjectInspector listOI;
    private PrimitiveObjectInspector listElemOI;
    private int maxItemId;
    private boolean bitsetInput;
    private float samplingRate;
    private boolean withReplacement;
    private Object[] forwardObjs;
    private IntWritable posItemId;
    private IntWritable negItemId;
    private BitSet _bitset;
    private Random _rand;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("bitset", "bitset_input", false, "Use Bitset for the input of pos_items [default:false]");
        opts.addOption("sampling", "sampling_rate", true, "Sampling rates of positive items [default: 1.0]");
        opts.addOption("with_replacement", false, "Do sampling with-replacement [default: false]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = null;
        boolean bitsetInput = false;
        float samplingRate = 1.0f;
        boolean withReplacement = false;
        if (argOIs.length == 3) {
            String args = HiveUtils.getConstString(argOIs[2]);
            cl = this.parseOptions(args);
            bitsetInput = cl.hasOption("bitset_input");
            withReplacement = cl.hasOption("with_replacement");
            samplingRate = Primitives.parseFloat(cl.getOptionValue("sampling_rate"), samplingRate);
            if (!withReplacement && samplingRate > 1.0f) {
                throw new UDFArgumentException("sampling_rate MUST be in less than or equals to 1 where withReplacement is false: " + samplingRate);
            }
        }
        this.bitsetInput = bitsetInput;
        this.samplingRate = samplingRate;
        this.withReplacement = withReplacement;
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentException("_FUNC_(array<long>, const long max_item_id [, const string options]) takes at least two arguments");
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        this.listElemOI = HiveUtils.asPrimitiveObjectInspector(this.listOI.getListElementObjectInspector());
        this.processOptions(argOIs);
        this.maxItemId = HiveUtils.getAsConstInt(argOIs[1]);
        if (this.maxItemId <= 0) {
            throw new UDFArgumentException("maxItemId MUST be greater than 0: " + this.maxItemId);
        }
        this.posItemId = new IntWritable();
        this.negItemId = new IntWritable();
        this.forwardObjs = new Object[]{this.posItemId, this.negItemId};
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WritableIntObjectInspector> fieldOIs = new ArrayList<WritableIntObjectInspector>();
        fieldNames.add("pos_item");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldNames.add("neg_item");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        int numPosItems;
        BitSet bits;
        if (this.bitsetInput) {
            if (this._rand == null) {
                this._rand = new Random(43L);
            }
            long[] longs = HiveUtils.asLongArray(args[0], this.listOI, this.listElemOI);
            bits = BitSet.valueOf(longs);
            numPosItems = bits.cardinality();
        } else {
            if (this._bitset == null) {
                this._bitset = bits = new BitSet();
                this._rand = new Random(43L);
            } else {
                bits = this._bitset;
                bits.clear();
            }
            numPosItems = HiveUtils.setBits(args[0], this.listOI, this.listElemOI, bits);
        }
        if (numPosItems == 0) {
            return;
        }
        int numNegItems = this.maxItemId + 1 - numPosItems;
        if (numNegItems == 0) {
            return;
        }
        if (numNegItems < 0) {
            throw new UDFArgumentException("maxItemId + 1 - numPosItems = " + this.maxItemId + " + 1 - " + numPosItems + " = " + numNegItems);
        }
        if (this.withReplacement) {
            this.sampleWithReplacement(numPosItems, numNegItems, bits);
        } else {
            this.sampleWithoutReplacement(numPosItems, numNegItems, bits);
        }
    }

    private void sampleWithReplacement(int numPosItems, int numNegItems, @Nonnull BitSet bitset) throws HiveException {
        int numSamples = Math.max(1, Math.round((float)numPosItems * this.samplingRate));
        for (int s = 0; s < numSamples; ++s) {
            int nth = this._rand.nextInt(numPosItems);
            int i = BitUtils.indexOfSetBit(bitset, nth);
            if (i == -1) {
                throw new UDFArgumentException("Cannot find a value for " + nth + "-th element in bitset " + bitset.toString() + " where numPosItems = " + numPosItems);
            }
            nth = this._rand.nextInt(numNegItems);
            int j = BitUtils.indexOfClearBit(bitset, nth, this.maxItemId);
            if (j < 0 || j > this.maxItemId) {
                throw new UDFArgumentException("j MUST be in [0," + this.maxItemId + "] but j was " + j);
            }
            this.posItemId.set(i);
            this.negItemId.set(j);
            this.forward(this.forwardObjs);
        }
    }

    private void sampleWithoutReplacement(int numPosItems, int numNegItems, @Nonnull BitSet bitset) throws HiveException {
        BitSet bitsetForPosSampling = bitset;
        BitSet bitsetForNegSampling = BitSet.valueOf(bitset.toLongArray());
        int numSamples = Math.max(1, Math.round((float)numPosItems * this.samplingRate));
        for (int s = 0; s < numSamples; ++s) {
            int nth = this._rand.nextInt(numPosItems);
            int i = BitUtils.indexOfSetBit(bitsetForPosSampling, nth);
            if (i == -1) {
                throw new UDFArgumentException("Cannot find a value for " + nth + "-th element in bitset " + bitset.toString() + " where numPosItems = " + numPosItems);
            }
            bitsetForPosSampling.set(i, false);
            --numPosItems;
            nth = this._rand.nextInt(numNegItems);
            int j = BitUtils.indexOfClearBit(bitsetForNegSampling, nth, this.maxItemId);
            if (j < 0 || j > this.maxItemId) {
                throw new UDFArgumentException("j MUST be in [0," + this.maxItemId + "] but j was " + j);
            }
            bitsetForNegSampling.set(j, true);
            --numNegItems;
            this.posItemId.set(i);
            this.negItemId.set(j);
            this.forward(this.forwardObjs);
            if (numPosItems <= 0) {
                return;
            }
            if (numNegItems > 0) continue;
            return;
        }
    }

    public void close() throws HiveException {
        this.listOI = null;
        this.listElemOI = null;
        this.forwardObjs = null;
        this.posItemId = null;
        this.negItemId = null;
        this._bitset = null;
        this._rand = null;
    }
}

