/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.ranking;

import hivemall.UDTFWithOptions;
import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.BitSet;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="populate_not_in", value="_FUNC_(list items, const int max_item_id [, const string options])- Returns a relation consists of <int item> that item does not exist in the given items")
public final class PopulateNotInUDTF
extends UDTFWithOptions {
    private ListObjectInspector listOI;
    private PrimitiveObjectInspector listElemOI;
    private int maxItemId;
    private boolean bitsetInput;
    private Object[] forwardObjs;
    private IntWritable populatedItemId;
    private BitSet _bitset;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("bitset", "bitset_input", false, "Use Bitset for the input of pos_items [default:false]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = null;
        boolean bitsetInput = false;
        if (argOIs.length == 3) {
            String args = HiveUtils.getConstString(argOIs[2]);
            cl = this.parseOptions(args);
            bitsetInput = cl.hasOption("bitset_input");
        }
        this.bitsetInput = bitsetInput;
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentException("bpr_sampling(array<long> items, const int max_item_id [, const string options]) takes at least two arguments");
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        this.listElemOI = HiveUtils.asPrimitiveObjectInspector(this.listOI.getListElementObjectInspector());
        this.processOptions(argOIs);
        this.maxItemId = HiveUtils.getAsConstInt(argOIs[1]);
        if (this.maxItemId <= 0) {
            throw new UDFArgumentException("maxItemId MUST be greater than 0: " + this.maxItemId);
        }
        this.populatedItemId = new IntWritable();
        this.forwardObjs = new Object[]{this.populatedItemId};
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WritableIntObjectInspector> fieldOIs = new ArrayList<WritableIntObjectInspector>();
        fieldNames.add("item_id");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        BitSet bits;
        Object arg0 = args[0];
        if (arg0 == null || this.listOI.getListLength(arg0) == 0) {
            this.populateAll();
            return;
        }
        if (this.bitsetInput) {
            long[] longs = HiveUtils.asLongArray(arg0, this.listOI, this.listElemOI);
            bits = BitSet.valueOf(longs);
        } else {
            if (this._bitset == null) {
                this._bitset = bits = new BitSet();
            } else {
                bits = this._bitset;
                bits.clear();
            }
            HiveUtils.setBits(arg0, this.listOI, this.listElemOI, bits);
        }
        this.populateItems(bits);
    }

    private void populateItems(@Nonnull BitSet bits) throws HiveException {
        int i = bits.nextClearBit(0);
        while (i <= this.maxItemId) {
            this.populatedItemId.set(i);
            this.forward(this.forwardObjs);
            i = bits.nextClearBit(i + 1);
        }
    }

    private void populateAll() throws HiveException {
        for (int i = 0; i <= this.maxItemId; ++i) {
            this.populatedItemId.set(i);
            this.forward(this.forwardObjs);
        }
    }

    public void close() throws HiveException {
        this.listOI = null;
        this.listElemOI = null;
        this.forwardObjs = null;
        this.populatedItemId = null;
        this._bitset = null;
    }
}

