/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.ranking;

import hivemall.utils.collections.lists.IntArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PositiveOnlyFeedback {
    @Nonnull
    protected final Int2ObjectMap<IntArrayList> rows = new Int2ObjectOpenHashMap<IntArrayList>(1024);
    protected int maxItemId;
    protected int totalFeedbacks;

    public PositiveOnlyFeedback(int maxItemId) {
        this.maxItemId = maxItemId;
        this.totalFeedbacks = 0;
    }

    public int getNumUsers() {
        return this.rows.size();
    }

    public void setMaxItemId(int maxItemId) {
        this.maxItemId = maxItemId;
    }

    public int getMaxItemId() {
        return this.maxItemId;
    }

    public int getTotalFeedbacks() {
        return this.totalFeedbacks;
    }

    @Nonnull
    public int[] getUsers() {
        int size = this.rows.size();
        int[] keys = new int[size];
        IntIterator itor = this.rows.keySet().iterator();
        for (int i = 0; i < size; ++i) {
            int key;
            if (!itor.hasNext()) {
                throw new IllegalStateException();
            }
            keys[i] = key = itor.nextInt();
        }
        return keys;
    }

    public void getUsers(@Nonnull BitSet bitset) {
        IntIterator intIterator = this.rows.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            bitset.set(key);
        }
    }

    @Nullable
    public IntArrayList getItems(int userId, boolean nonEmptyCheck) {
        IntArrayList items = (IntArrayList)this.rows.get(userId);
        if (nonEmptyCheck && (items == null || items.isEmpty())) {
            throw new IllegalStateException("Found empty items for user: " + userId);
        }
        return items;
    }

    public void removeFeedback(int userId) {
        IntArrayList items = (IntArrayList)this.rows.remove(userId);
        if (items != null && !items.isEmpty()) {
            this.totalFeedbacks -= items.size();
        }
    }

    public void addFeedback(int userId, @Nonnull IntArrayList itemIds) {
        PositiveOnlyFeedback.validateIndex(userId);
        if (itemIds.isEmpty()) {
            return;
        }
        IntArrayList old = this.rows.put(userId, itemIds);
        if (old != null) {
            throw new IllegalStateException("Entry already exists in row: " + userId);
        }
        this.totalFeedbacks += itemIds.size();
    }

    protected static void validateIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index is not allowed: " + index);
        }
    }

    protected static void validateIndex(int user, int item) {
        if (user < 0) {
            throw new IllegalArgumentException("Negative user index is not allowed: " + user);
        }
        if (item < 0) {
            throw new IllegalArgumentException("Negative item index is not allowed: " + item);
        }
    }
}

