/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.scaling;

import hivemall.utils.hadoop.WritableUtils;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;

@Description(name="rescale", value="_FUNC_(value, min, max) - Returns rescaled value by min-max normalization")
@UDFType(deterministic=true, stateful=false)
public final class RescaleUDF
extends UDF {
    @Nullable
    public FloatWritable evaluate(@Nullable Double value, @CheckForNull Double min, @CheckForNull Double max) throws HiveException {
        return this.evaluate(RescaleUDF.double2Float(value), RescaleUDF.double2Float(min), RescaleUDF.double2Float(max));
    }

    @Nullable
    public FloatWritable evaluate(@Nullable Float value, @CheckForNull Float min, @CheckForNull Float max) throws HiveException {
        if (value == null) {
            return null;
        }
        if (min == null) {
            throw new HiveException("min should not be null");
        }
        if (max == null) {
            throw new HiveException("max should not be null");
        }
        return WritableUtils.val(RescaleUDF.min_max_normalization(value.floatValue(), min.floatValue(), max.floatValue()));
    }

    @Nullable
    public Text evaluate(@Nullable String s, @CheckForNull Double min, @CheckForNull Double max) throws HiveException {
        return this.evaluate(s, RescaleUDF.double2Float(min), RescaleUDF.double2Float(max));
    }

    @Nullable
    public Text evaluate(@Nullable String s, @CheckForNull Float min, @CheckForNull Float max) throws HiveException {
        float v;
        if (s == null) {
            return null;
        }
        if (min == null) {
            throw new HiveException("min should not be null");
        }
        if (max == null) {
            throw new HiveException("max should not be null");
        }
        String[] fv = s.split(":");
        if (fv.length != 2) {
            throw new HiveException(String.format("Invalid feature value representation: %s", s));
        }
        try {
            v = Float.parseFloat(fv[1]);
        }
        catch (NumberFormatException e) {
            throw new HiveException(String.format("Invalid feature value representation: %s, %s can't parse to float.", s, fv[1]));
        }
        float scaled_v = RescaleUDF.min_max_normalization(v, min.floatValue(), max.floatValue());
        String ret = fv[0] + ':' + scaled_v;
        return WritableUtils.val(ret);
    }

    private static float min_max_normalization(float value, float min, float max) throws HiveException {
        if (min > max) {
            throw new HiveException("min value `" + min + "` SHOULD be less than max value `" + max + '`');
        }
        if (min == max) {
            return 0.5f;
        }
        if (value < min) {
            return 0.0f;
        }
        if (value > max) {
            return 1.0f;
        }
        return (value - min) / (max - min);
    }

    @Nullable
    private static Float double2Float(@Nullable Double value) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }
}

