/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.scaling;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;

@Description(name="zscore", value="_FUNC_(value, mean, stddev) - Returns a standard score (zscore)")
@UDFType(deterministic=true, stateful=false)
public final class ZScoreUDF
extends UDF {
    public FloatWritable evaluate(double value, double mean, double stddev) {
        if (stddev == 0.0) {
            return new FloatWritable(0.0f);
        }
        float v = (float)((value - mean) / stddev);
        return new FloatWritable(v);
    }

    public FloatWritable evaluate(float value, float mean, float stddev) {
        if (stddev == 0.0f) {
            return new FloatWritable(0.0f);
        }
        float v = (value - mean) / stddev;
        return new FloatWritable(v);
    }
}

