/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.trans;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="add_field_indices", value="_FUNC_(array<string> features) - Returns arrays of string that field indices (<field>:<feature>)* are augmented")
@UDFType(deterministic=true, stateful=false)
public final class AddFieldIndicesUDF
extends GenericUDF {
    private ListObjectInspector listOI;

    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("Expected a single argument: " + argOIs.length);
        }
        this.listOI = HiveUtils.asListOI(argOIs[0]);
        if (!HiveUtils.isStringOI(this.listOI.getListElementObjectInspector())) {
            throw new UDFArgumentException("Expected array<string> but got " + argOIs[0]);
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }

    public List<String> evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        Preconditions.checkArgument(args.length == 1);
        String[] features = HiveUtils.asStringArray(args[0], this.listOI);
        if (features == null) {
            return null;
        }
        ArrayList<String> augmented = new ArrayList<String>(features.length);
        for (int i = 0; i < features.length; ++i) {
            String f = features[i];
            if (f == null) continue;
            augmented.add(i + 1 + ":" + f);
        }
        return augmented;
    }

    public String getDisplayString(String[] args) {
        return "add_field_indices( " + Arrays.toString(args) + " )";
    }
}

