/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.trans;

import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="indexed_features", value="_FUNC_(double v1, double v2, ...) - Returns a list of features as array<string>: [1:v1, 2:v2, ..]")
@UDFType(deterministic=true, stateful=false)
public final class IndexedFeatures
extends GenericUDF {
    private List<String> list;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs < 1) {
            throw new UDFArgumentLengthException("features(v1, ..) requires at least 1 arguments, got " + argOIs.length);
        }
        this.list = null;
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
    }

    public List<String> evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int size = arguments.length;
        if (this.list == null) {
            this.list = new ArrayList<String>(size);
        } else {
            this.list.clear();
        }
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < size; ++i) {
            String s1;
            Object o = arguments[i].get();
            if (o == null || (s1 = o.toString()).isEmpty()) continue;
            String s2 = buf.append(i + 1).append(':').append(s1).toString();
            this.list.add(s2);
            StringUtils.clear(buf);
        }
        return this.list;
    }

    public String getDisplayString(String[] children) {
        return "indexed_features(" + Arrays.toString(children) + ")";
    }
}

