/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.trans;

import hivemall.UDFWithOptions;
import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="quantitative_features", value="_FUNC_(array<string> featureNames, feature1, feature2, .. [, const string options]) - Returns a feature vector array<string>")
@UDFType(deterministic=true, stateful=false)
public final class QuantitativeFeaturesUDF
extends UDFWithOptions {
    private String[] _featureNames;
    private PrimitiveObjectInspector[] _inputOIs;
    private List<Text> _result;
    private boolean _emitNull = false;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("emit_null", false, "Whether to emit NULL [default: false]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(@Nonnull String optionValue) throws UDFArgumentException {
        CommandLine cl = this.parseOptions(optionValue);
        this._emitNull = cl.hasOption("emit_null");
        return cl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        int numFeatures;
        int numArgOIs = argOIs.length;
        if (numArgOIs < 2) {
            throw new UDFArgumentException("argOIs.length must be greater that or equals to 2: " + numArgOIs);
        }
        this._featureNames = HiveUtils.getConstStringArray(argOIs[0]);
        if (this._featureNames == null) {
            throw new UDFArgumentException("#featureNames should not be null");
        }
        int numFeatureNames = this._featureNames.length;
        if (numFeatureNames < 1) {
            throw new UDFArgumentException("#featureNames must be greater than or equals to 1: " + numFeatureNames);
        }
        for (String featureName : this._featureNames) {
            if (featureName == null) {
                throw new UDFArgumentException("featureName should not be null: " + Arrays.toString(this._featureNames));
            }
            if (featureName.indexOf(58) == -1) continue;
            throw new UDFArgumentException("featureName should not include colon: " + featureName);
        }
        int lastArgIndex = numArgOIs - 1;
        if (lastArgIndex > numFeatureNames) {
            if (lastArgIndex != numFeatureNames + 1 || !HiveUtils.isConstString(argOIs[lastArgIndex])) throw new UDFArgumentException("Unexpected arguments for _FUNC_(const array<string> featureNames, feature1, feature2, .. [, const string options])");
            String optionValue = HiveUtils.getConstString(argOIs[lastArgIndex]);
            this.processOptions(optionValue);
            numFeatures = numArgOIs - 2;
        } else {
            numFeatures = lastArgIndex;
        }
        if (numFeatureNames != numFeatures) {
            throw new UDFArgumentLengthException("#featureNames '" + numFeatureNames + "' != #features '" + numFeatures + "'");
        }
        this._inputOIs = new PrimitiveObjectInspector[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            ObjectInspector oi = argOIs[i + 1];
            this._inputOIs[i] = HiveUtils.asDoubleCompatibleOI(oi);
        }
        this._result = new ArrayList<Text>(numFeatures);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    public List<Text> evaluate(@Nonnull GenericUDF.DeferredObject[] arguments) throws HiveException {
        this._result.clear();
        int size = this._featureNames.length;
        for (int i = 0; i < size; ++i) {
            Text f;
            String s;
            Object argument = arguments[i + 1].get();
            if (argument == null) {
                if (!this._emitNull) continue;
                this._result.add(null);
                continue;
            }
            PrimitiveObjectInspector oi = this._inputOIs[i];
            if (oi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING && (s = argument.toString()).isEmpty()) {
                if (!this._emitNull) continue;
                this._result.add(null);
                continue;
            }
            double v = PrimitiveObjectInspectorUtils.getDouble((Object)argument, (PrimitiveObjectInspector)oi);
            if (v != 0.0) {
                f = new Text(this._featureNames[i] + ':' + v);
                this._result.add(f);
                continue;
            }
            if (!this._emitNull) continue;
            f = new Text(this._featureNames[i] + ":0");
            this._result.add(f);
        }
        return this._result;
    }

    public String getDisplayString(String[] children) {
        return "quantitative_features(" + Arrays.toString(children) + ")";
    }
}

