/*
 * Decompiled with CFR 0.152.
 */
package hivemall.geospatial;

import hivemall.utils.geospatial.GeoSpatialUtils;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="haversine_distance", value="_FUNC_(double lat1, double lon1, double lat2, double lon2, [const boolean mile=false])::double - return distance between two locations in km [or miles] using `haversine` formula", extended="Usage: select latlon_distance(lat1, lon1, lat2, lon2) from ...")
@UDFType(deterministic=true, stateful=false)
public final class HaversineDistanceUDF
extends GenericUDF {
    private PrimitiveObjectInspector lat1OI;
    private PrimitiveObjectInspector lon1OI;
    private PrimitiveObjectInspector lat2OI;
    private PrimitiveObjectInspector lon2OI;
    private boolean inMiles;
    private DoubleWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 4 && argOIs.length != 5) {
            throw new UDFArgumentException("_FUNC_ takes 4 or 5 arguments: " + argOIs.length);
        }
        this.lat1OI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
        this.lon1OI = HiveUtils.asDoubleCompatibleOI(argOIs[1]);
        this.lat2OI = HiveUtils.asDoubleCompatibleOI(argOIs[2]);
        this.lon2OI = HiveUtils.asDoubleCompatibleOI(argOIs[3]);
        this.inMiles = argOIs.length == 5 && HiveUtils.getConstBoolean(argOIs[4]);
        this.result = new DoubleWritable();
        return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
    }

    public DoubleWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        double distance;
        Object arg0 = arguments[0].get();
        Object arg1 = arguments[1].get();
        Object arg2 = arguments[2].get();
        Object arg3 = arguments[3].get();
        if (arg0 == null || arg1 == null || arg2 == null || arg3 == null) {
            return null;
        }
        double lat1 = PrimitiveObjectInspectorUtils.getDouble((Object)arg0, (PrimitiveObjectInspector)this.lat1OI);
        double lon1 = PrimitiveObjectInspectorUtils.getDouble((Object)arg1, (PrimitiveObjectInspector)this.lon1OI);
        double lat2 = PrimitiveObjectInspectorUtils.getDouble((Object)arg2, (PrimitiveObjectInspector)this.lat2OI);
        double lon2 = PrimitiveObjectInspectorUtils.getDouble((Object)arg3, (PrimitiveObjectInspector)this.lon2OI);
        try {
            distance = GeoSpatialUtils.haversineDistance(lat1, lon1, lat2, lon2);
        }
        catch (IllegalArgumentException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
        if (this.inMiles) {
            double miles = distance / 1.609344;
            this.result.set(miles);
        } else {
            this.result.set(distance);
        }
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "haversine_distance(" + Arrays.toString(children) + ")";
    }
}

