/*
 * Decompiled with CFR 0.152.
 */
package hivemall.geospatial;

import hivemall.utils.geospatial.GeoSpatialUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;

@Description(name="lon2tilex", value="_FUNC_(double lon, int zoom)::int - Returns the tile number of the given longitude and zoom level")
@UDFType(deterministic=true, stateful=false)
public final class Lon2TileXUDF
extends GenericUDF {
    private PrimitiveObjectInspector lonOI;
    private PrimitiveObjectInspector zoomOI;
    private IntWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("_FUNC_ takes exactly 2 arguments: " + argOIs.length);
        }
        this.lonOI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
        this.zoomOI = HiveUtils.asIntegerOI(argOIs[1]);
        this.result = new IntWritable();
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    public IntWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int x;
        Object arg0 = arguments[0].get();
        Object arg1 = arguments[1].get();
        if (arg0 == null) {
            return null;
        }
        if (arg1 == null) {
            throw new UDFArgumentException("zoom level should not be null");
        }
        double lon = PrimitiveObjectInspectorUtils.getDouble((Object)arg0, (PrimitiveObjectInspector)this.lonOI);
        int zoom = PrimitiveObjectInspectorUtils.getInt((Object)arg1, (PrimitiveObjectInspector)this.zoomOI);
        Preconditions.checkArgument(zoom >= 0, "Invalid zoom level", UDFArgumentException.class);
        try {
            x = GeoSpatialUtils.lon2tilex(lon, zoom);
        }
        catch (IllegalArgumentException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
        this.result.set(x);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "lon2tilex(" + Arrays.toString(children) + ")";
    }
}

