/*
 * Decompiled with CFR 0.152.
 */
package hivemall.geospatial;

import hivemall.utils.geospatial.GeoSpatialUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.LongWritable;

@Description(name="tile", value="_FUNC_(double lat, double lon, int zoom)::bigint - Returns a tile number 2^2n where n is zoom level.\n_FUNC_(lat,lon,zoom) = xtile(lon,zoom) + ytile(lat,zoom) * 2^zoom", extended="refer https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames for detail")
@UDFType(deterministic=true, stateful=false)
public final class TileUDF
extends GenericUDF {
    private PrimitiveObjectInspector latOI;
    private PrimitiveObjectInspector lonOI;
    private PrimitiveObjectInspector zoomOI;
    private LongWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 3) {
            throw new UDFArgumentException("_FUNC_ takes exactly 3 arguments: " + argOIs.length);
        }
        this.latOI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
        this.lonOI = HiveUtils.asDoubleCompatibleOI(argOIs[1]);
        this.zoomOI = HiveUtils.asIntegerOI(argOIs[2]);
        this.result = new LongWritable();
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    public LongWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        long tile;
        Object arg0 = arguments[0].get();
        Object arg1 = arguments[1].get();
        Object arg2 = arguments[2].get();
        if (arg0 == null || arg1 == null) {
            return null;
        }
        if (arg2 == null) {
            throw new UDFArgumentException("zoom level is null");
        }
        double lat = PrimitiveObjectInspectorUtils.getDouble((Object)arg0, (PrimitiveObjectInspector)this.latOI);
        double lon = PrimitiveObjectInspectorUtils.getDouble((Object)arg1, (PrimitiveObjectInspector)this.lonOI);
        int zoom = PrimitiveObjectInspectorUtils.getInt((Object)arg2, (PrimitiveObjectInspector)this.zoomOI);
        Preconditions.checkArgument(zoom >= 0, "Invalid zoom level", UDFArgumentException.class);
        try {
            tile = GeoSpatialUtils.tile(lat, lon, zoom);
        }
        catch (IllegalArgumentException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
        this.result.set(tile);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "tile(" + Arrays.toString(children) + ")";
    }
}

