/*
 * Decompiled with CFR 0.152.
 */
package hivemall.geospatial;

import hivemall.utils.geospatial.GeoSpatialUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="tiley2lat", value="_FUNC_(int y, int zoom)::double - Returns latitude of the given tile y and zoom level")
@UDFType(deterministic=true, stateful=false)
public final class TileY2LatUDF
extends GenericUDF {
    private PrimitiveObjectInspector yOI;
    private PrimitiveObjectInspector zoomOI;
    private DoubleWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("_FUNC_ takes exactly 2 arguments: " + argOIs.length);
        }
        this.yOI = HiveUtils.asIntegerOI(argOIs[0]);
        this.zoomOI = HiveUtils.asIntegerOI(argOIs[1]);
        this.result = new DoubleWritable();
        return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
    }

    public DoubleWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        double lat;
        Object arg0 = arguments[0].get();
        Object arg1 = arguments[1].get();
        if (arg0 == null) {
            return null;
        }
        if (arg1 == null) {
            throw new UDFArgumentException("zoom level should not be null");
        }
        int y = PrimitiveObjectInspectorUtils.getInt((Object)arg0, (PrimitiveObjectInspector)this.yOI);
        int zoom = PrimitiveObjectInspectorUtils.getInt((Object)arg1, (PrimitiveObjectInspector)this.zoomOI);
        Preconditions.checkArgument(zoom >= 0, "Invalid zoom level", UDFArgumentException.class);
        try {
            lat = GeoSpatialUtils.tiley2lat(y, zoom);
        }
        catch (IllegalArgumentException ex) {
            throw new UDFArgumentException((Throwable)ex);
        }
        this.result.set(lat);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "tiley2lat(" + Arrays.toString(children) + ")";
    }
}

