/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.data;

import hivemall.codehaus.jackson.JsonFactory;
import hivemall.codehaus.jackson.JsonParseException;
import hivemall.codehaus.jackson.JsonParser;
import hivemall.codehaus.jackson.JsonToken;
import hivemall.hcatalog.common.HCatException;
import hivemall.hcatalog.data.DefaultHCatRecord;
import hivemall.hcatalog.data.HCatRecordObjectInspector;
import hivemall.hcatalog.data.HCatRecordObjectInspectorFactory;
import hivemall.hcatalog.data.schema.HCatFieldSchema;
import hivemall.hcatalog.data.schema.HCatSchema;
import hivemall.hcatalog.data.schema.HCatSchemaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerDe
implements SerDe {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerDe.class);
    private List<String> columnNames;
    private HCatSchema schema;
    private JsonFactory jsonFactory = null;
    private HCatRecordObjectInspector cachedObjectInspector;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        LOG.debug("Initializing JsonSerDe");
        LOG.debug("props to serde: {}", tbl.entrySet());
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        LOG.debug("columns: {}, {}", (Object)columnNameProperty, this.columnNames);
        LOG.debug("types: {}, {} ", (Object)columnTypeProperty, columnTypes);
        assert (this.columnNames.size() == columnTypes.size());
        StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, columnTypes);
        this.cachedObjectInspector = HCatRecordObjectInspectorFactory.getHCatRecordObjectInspector(rowTypeInfo);
        try {
            this.schema = HCatSchemaUtils.getHCatSchema((TypeInfo)rowTypeInfo).get(0).getStructSubSchema();
            LOG.debug("schema : {}", (Object)this.schema);
            LOG.debug("fields : {}", this.schema.getFieldNames());
        }
        catch (HCatException e) {
            throw new SerDeException((Throwable)e);
        }
        this.jsonFactory = new JsonFactory();
    }

    public Object deserialize(Writable blob) throws SerDeException {
        Text t = (Text)blob;
        ArrayList<Object> r = new ArrayList<Object>(Collections.nCopies(this.columnNames.size(), null));
        try {
            JsonToken token;
            JsonParser p = this.jsonFactory.createJsonParser(new ByteArrayInputStream(t.getBytes()));
            if (p.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Start token not found where expected");
            }
            while ((token = p.nextToken()) != JsonToken.END_OBJECT && token != null) {
                this.populateRecord(r, token, p, this.schema);
            }
        }
        catch (JsonParseException e) {
            LOG.warn("Error [{}] parsing json text [{}].", (Object)e, (Object)t);
            LOG.debug(null, (Throwable)e);
            throw new SerDeException((Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error [{}] parsing json text [{}].", (Object)e, (Object)t);
            LOG.debug(null, (Throwable)e);
            throw new SerDeException((Throwable)e);
        }
        return new DefaultHCatRecord(r);
    }

    private void populateRecord(List<Object> r, JsonToken token, JsonParser p, HCatSchema s) throws IOException {
        if (token != JsonToken.FIELD_NAME) {
            throw new IOException("Field name expected");
        }
        String fieldName = p.getText();
        Integer fpos = s.getPosition(fieldName);
        if (fpos == null) {
            fpos = this.getPositionFromHiveInternalColumnName(fieldName);
            LOG.debug("NPE finding position for field [{}] in schema [{}], attempting to check if it is an internal column name like _col0", (Object)fieldName, (Object)s);
            if (fpos == -1) {
                this.skipValue(p);
                return;
            }
            if (!fieldName.equalsIgnoreCase(this.getHiveInternalColumnName(fpos))) {
                LOG.error("Hive internal column name {} and position encoding {} for the column name are at odds", (Object)fieldName, (Object)fpos);
                throw new IOException("Hive internal column name (" + fieldName + ") and position encoding (" + fpos + ") for the column name are at odds");
            }
        }
        HCatFieldSchema hcatFieldSchema = s.getFields().get(fpos);
        Object currField = this.extractCurrentField(p, hcatFieldSchema, false);
        r.set(fpos, currField);
    }

    public String getHiveInternalColumnName(int fpos) {
        return HiveConf.getColumnInternalName((int)fpos);
    }

    public int getPositionFromHiveInternalColumnName(String internalName) {
        Pattern internalPattern = Pattern.compile("_col([0-9]+)");
        Matcher m = internalPattern.matcher(internalName);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(1));
    }

    private void skipValue(JsonParser p) throws JsonParseException, IOException {
        JsonToken valueToken = p.nextToken();
        if (valueToken == JsonToken.START_ARRAY || valueToken == JsonToken.START_OBJECT) {
            p.skipChildren();
        }
    }

    private Object extractCurrentField(JsonParser p, HCatFieldSchema hcatFieldSchema, boolean isTokenCurrent) throws IOException {
        Cloneable val = null;
        JsonToken valueToken = isTokenCurrent ? p.getCurrentToken() : p.nextToken();
        switch (hcatFieldSchema.getType()) {
            case INT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Integer.valueOf(p.getIntValue());
                break;
            }
            case TINYINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Byte.valueOf(p.getByteValue());
                break;
            }
            case SMALLINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Short.valueOf(p.getShortValue());
                break;
            }
            case BIGINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Long.valueOf(p.getLongValue());
                break;
            }
            case BOOLEAN: {
                String bval;
                String string = bval = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                if (bval != null) {
                    val = Boolean.valueOf(bval);
                    break;
                }
                val = null;
                break;
            }
            case FLOAT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Float.valueOf(p.getFloatValue());
                break;
            }
            case DOUBLE: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Double.valueOf(p.getDoubleValue());
                break;
            }
            case STRING: {
                val = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                break;
            }
            case BINARY: {
                throw new IOException("JsonSerDe does not support BINARY type");
            }
            case DATE: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Date.valueOf(p.getText());
                break;
            }
            case TIMESTAMP: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Timestamp.valueOf(p.getText());
                break;
            }
            case DECIMAL: {
                val = valueToken == JsonToken.VALUE_NULL ? null : HiveDecimal.create((String)p.getText());
                break;
            }
            case VARCHAR: {
                int vLen = ((BaseCharTypeInfo)hcatFieldSchema.getTypeInfo()).getLength();
                val = valueToken == JsonToken.VALUE_NULL ? null : new HiveVarchar(p.getText(), vLen);
                break;
            }
            case CHAR: {
                int cLen = ((BaseCharTypeInfo)hcatFieldSchema.getTypeInfo()).getLength();
                val = valueToken == JsonToken.VALUE_NULL ? null : new HiveChar(p.getText(), cLen);
                break;
            }
            case ARRAY: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_ARRAY) {
                    throw new IOException("Start of Array expected");
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                while ((valueToken = p.nextToken()) != JsonToken.END_ARRAY) {
                    arr.add(this.extractCurrentField(p, hcatFieldSchema.getArrayElementSchema().get(0), true));
                }
                val = arr;
                break;
            }
            case MAP: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                HCatFieldSchema valueSchema = hcatFieldSchema.getMapValueSchema().get(0);
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    Object k = this.getObjectOfCorrespondingPrimitiveType(p.getCurrentName(), hcatFieldSchema.getMapKeyTypeInfo());
                    Object v = valueSchema.getType() == HCatFieldSchema.Type.STRUCT ? this.extractCurrentField(p, valueSchema, false) : this.extractCurrentField(p, valueSchema, true);
                    map.put(k, v);
                }
                val = map;
                break;
            }
            case STRUCT: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                HCatSchema subSchema = hcatFieldSchema.getStructSubSchema();
                int sz = subSchema.getFieldNames().size();
                ArrayList<Object> struct = new ArrayList<Object>(Collections.nCopies(sz, null));
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    this.populateRecord(struct, valueToken, p, subSchema);
                }
                val = struct;
                break;
            }
            default: {
                LOG.error("Unknown type found: " + (Object)((Object)hcatFieldSchema.getType()));
                return null;
            }
        }
        return val;
    }

    private Object getObjectOfCorrespondingPrimitiveType(String s, PrimitiveTypeInfo mapKeyType) throws IOException {
        switch (HCatFieldSchema.Type.getPrimitiveHType(mapKeyType)) {
            case INT: {
                return Integer.valueOf(s);
            }
            case TINYINT: {
                return Byte.valueOf(s);
            }
            case SMALLINT: {
                return Short.valueOf(s);
            }
            case BIGINT: {
                return Long.valueOf(s);
            }
            case BOOLEAN: {
                return s.equalsIgnoreCase("true");
            }
            case FLOAT: {
                return Float.valueOf(s);
            }
            case DOUBLE: {
                return Double.valueOf(s);
            }
            case STRING: {
                return s;
            }
            case BINARY: {
                throw new IOException("JsonSerDe does not support BINARY type");
            }
            case DATE: {
                return Date.valueOf(s);
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(s);
            }
            case DECIMAL: {
                return HiveDecimal.create((String)s);
            }
            case VARCHAR: {
                return new HiveVarchar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
            case CHAR: {
                return new HiveChar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
        }
        throw new IOException("Could not convert from string to map type " + mapKeyType.getTypeName());
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        StringBuilder sb = new StringBuilder();
        try {
            StructObjectInspector soi = (StructObjectInspector)objInspector;
            List structFields = soi.getAllStructFieldRefs();
            assert (this.columnNames.size() == structFields.size());
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append("{");
                for (int i = 0; i < structFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.appendWithQuotes(sb, this.columnNames.get(i));
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, soi.getStructFieldData(obj, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                }
                sb.append("}");
            }
        }
        catch (IOException e) {
            LOG.warn("Error generating json text from object.", (Throwable)e);
            throw new SerDeException((Throwable)e);
        }
        return new Text(sb.toString());
    }

    private static StringBuilder appendWithQuotes(StringBuilder sb, String value) {
        return sb == null ? null : sb.append('\"').append(value).append('\"');
    }

    private static void buildJSONString(StringBuilder sb, Object o, ObjectInspector oi) throws IOException {
        block0 : switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                if (o == null) {
                    sb.append("null");
                    break;
                }
                switch (poi.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean b = ((BooleanObjectInspector)poi).get(o);
                        sb.append(b ? "true" : "false");
                        break block0;
                    }
                    case BYTE: {
                        sb.append(((ByteObjectInspector)poi).get(o));
                        break block0;
                    }
                    case SHORT: {
                        sb.append(((ShortObjectInspector)poi).get(o));
                        break block0;
                    }
                    case INT: {
                        sb.append(((IntObjectInspector)poi).get(o));
                        break block0;
                    }
                    case LONG: {
                        sb.append(((LongObjectInspector)poi).get(o));
                        break block0;
                    }
                    case FLOAT: {
                        sb.append(((FloatObjectInspector)poi).get(o));
                        break block0;
                    }
                    case DOUBLE: {
                        sb.append(((DoubleObjectInspector)poi).get(o));
                        break block0;
                    }
                    case STRING: {
                        String s = SerDeUtils.escapeString((String)((StringObjectInspector)poi).getPrimitiveJavaObject(o));
                        JsonSerDe.appendWithQuotes(sb, s);
                        break block0;
                    }
                    case BINARY: {
                        throw new IOException("JsonSerDe does not support BINARY type");
                    }
                    case DATE: {
                        Date d = ((DateObjectInspector)poi).getPrimitiveJavaObject(o);
                        JsonSerDe.appendWithQuotes(sb, d.toString());
                        break block0;
                    }
                    case TIMESTAMP: {
                        Timestamp t = ((TimestampObjectInspector)poi).getPrimitiveJavaObject(o);
                        JsonSerDe.appendWithQuotes(sb, t.toString());
                        break block0;
                    }
                    case DECIMAL: {
                        sb.append(((HiveDecimalObjectInspector)poi).getPrimitiveJavaObject(o));
                        break block0;
                    }
                    case VARCHAR: {
                        JsonSerDe.appendWithQuotes(sb, ((HiveVarcharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
                        break block0;
                    }
                    case CHAR: {
                        JsonSerDe.appendWithQuotes(sb, ((HiveCharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown primitive type: " + poi.getPrimitiveCategory());
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
                List olist = loi.getList(o);
                if (olist == null) {
                    sb.append("null");
                    break;
                }
                sb.append("[");
                for (int i = 0; i < olist.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.buildJSONString(sb, olist.get(i), listElementObjectInspector);
                }
                sb.append("]");
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
                ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
                Map omap = moi.getMap(o);
                if (omap == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                boolean first = true;
                for (Map.Entry entry : omap.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    Map.Entry e = entry;
                    StringBuilder keyBuilder = new StringBuilder();
                    JsonSerDe.buildJSONString(keyBuilder, e.getKey(), mapKeyObjectInspector);
                    String keyString = keyBuilder.toString().trim();
                    if (!keyString.isEmpty() && keyString.charAt(0) != '\"') {
                        JsonSerDe.appendWithQuotes(sb, keyString);
                    } else {
                        sb.append(keyString);
                    }
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, e.getValue(), mapValueObjectInspector);
                }
                sb.append("}");
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List structFields = soi.getAllStructFieldRefs();
                if (o == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                for (int i = 0; i < structFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.appendWithQuotes(sb, ((StructField)structFields.get(i)).getFieldName());
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, soi.getStructFieldData(o, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                }
                sb.append("}");
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                if (o == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                sb.append(uoi.getTag(o));
                sb.append(':');
                JsonSerDe.buildJSONString(sb, uoi.getField(o), (ObjectInspector)uoi.getObjectInspectors().get(uoi.getTag(o)));
                sb.append("}");
                break;
            }
            default: {
                throw new RuntimeException("Unknown type in ObjectInspector!");
            }
        }
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

