/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.data.transfer;

import hivemall.hcatalog.data.transfer.HCatReader;
import hivemall.hcatalog.data.transfer.HCatWriter;
import hivemall.hcatalog.data.transfer.ReadEntity;
import hivemall.hcatalog.data.transfer.ReaderContext;
import hivemall.hcatalog.data.transfer.WriteEntity;
import hivemall.hcatalog.data.transfer.WriterContext;
import hivemall.hcatalog.data.transfer.impl.HCatInputFormatReader;
import hivemall.hcatalog.data.transfer.impl.HCatOutputFormatWriter;
import hivemall.hcatalog.data.transfer.state.DefaultStateProvider;
import hivemall.hcatalog.data.transfer.state.StateProvider;
import java.util.Map;

public class DataTransferFactory {
    public static HCatReader getHCatReader(ReadEntity re, Map<String, String> config) {
        return new HCatInputFormatReader(re, config);
    }

    public static HCatReader getHCatReader(ReaderContext context, int slaveNumber) {
        return DataTransferFactory.getHCatReader(context, slaveNumber, DefaultStateProvider.get());
    }

    public static HCatReader getHCatReader(ReaderContext context, int slaveNumber, StateProvider sp2) {
        return new HCatInputFormatReader(context, slaveNumber, sp2);
    }

    public static HCatWriter getHCatWriter(WriteEntity we, Map<String, String> config) {
        return new HCatOutputFormatWriter(we, config);
    }

    public static HCatWriter getHCatWriter(WriterContext cntxt) {
        return DataTransferFactory.getHCatWriter(cntxt, DefaultStateProvider.get());
    }

    public static HCatWriter getHCatWriter(WriterContext cntxt, StateProvider sp2) {
        return new HCatOutputFormatWriter(cntxt, sp2);
    }
}

