/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.data.transfer;

import hivemall.hcatalog.common.HCatException;
import hivemall.hcatalog.data.HCatRecord;
import hivemall.hcatalog.data.transfer.ReadEntity;
import hivemall.hcatalog.data.transfer.ReaderContext;
import hivemall.hcatalog.data.transfer.state.StateProvider;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class HCatReader {
    protected ReadEntity re;
    protected Configuration conf;
    protected ReaderContext info;
    protected StateProvider sp;

    public abstract ReaderContext prepareRead() throws HCatException;

    public abstract Iterator<HCatRecord> read() throws HCatException;

    protected HCatReader(ReadEntity re, Map<String, String> config) {
        this(config);
        this.re = re;
    }

    protected HCatReader(Configuration config, StateProvider sp2) {
        this.conf = config;
        this.sp = sp2;
    }

    private HCatReader(Map<String, String> config) {
        Configuration conf = new Configuration();
        if (null != config) {
            for (Map.Entry<String, String> kv : config.entrySet()) {
                conf.set(kv.getKey(), kv.getValue());
            }
        }
        this.conf = conf;
    }
}

