/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.data.transfer.impl;

import hivemall.hcatalog.common.ErrorType;
import hivemall.hcatalog.common.HCatException;
import hivemall.hcatalog.data.HCatRecord;
import hivemall.hcatalog.data.transfer.HCatReader;
import hivemall.hcatalog.data.transfer.ReadEntity;
import hivemall.hcatalog.data.transfer.ReaderContext;
import hivemall.hcatalog.data.transfer.impl.ReaderContextImpl;
import hivemall.hcatalog.data.transfer.state.StateProvider;
import hivemall.hcatalog.mapreduce.HCatInputFormat;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class HCatInputFormatReader
extends HCatReader {
    private InputSplit split;

    public HCatInputFormatReader(ReaderContext context, int slaveNumber, StateProvider sp2) {
        super(((ReaderContextImpl)context).getConf(), sp2);
        this.split = ((ReaderContextImpl)context).getSplits().get(slaveNumber);
    }

    public HCatInputFormatReader(ReadEntity info, Map<String, String> config) {
        super(info, config);
    }

    @Override
    public ReaderContext prepareRead() throws HCatException {
        try {
            Job job = new Job(this.conf);
            HCatInputFormat hcif = HCatInputFormat.setInput(job, this.re.getDbName(), this.re.getTableName(), this.re.getFilterString());
            ReaderContextImpl cntxt = new ReaderContextImpl();
            cntxt.setInputSplits(hcif.getSplits(ShimLoader.getHadoopShims().getHCatShim().createJobContext(job.getConfiguration(), null)));
            cntxt.setConf(job.getConfiguration());
            return cntxt;
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
    }

    @Override
    public Iterator<HCatRecord> read() throws HCatException {
        RecordReader<WritableComparable, HCatRecord> rr;
        HCatInputFormat inpFmt = new HCatInputFormat();
        try {
            TaskAttemptContext cntxt = ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(this.conf, new TaskAttemptID());
            rr = inpFmt.createRecordReader(this.split, cntxt);
            rr.initialize(this.split, cntxt);
        }
        catch (IOException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED, (Throwable)e);
        }
        return new HCatRecordItr(rr);
    }

    private static class HCatRecordItr
    implements Iterator<HCatRecord> {
        private RecordReader<WritableComparable, HCatRecord> curRecReader;

        HCatRecordItr(RecordReader<WritableComparable, HCatRecord> rr) {
            this.curRecReader = rr;
        }

        @Override
        public boolean hasNext() {
            try {
                boolean retVal = this.curRecReader.nextKeyValue();
                if (retVal) {
                    return true;
                }
                this.curRecReader.close();
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public HCatRecord next() {
            try {
                return (HCatRecord)this.curRecReader.getCurrentValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not allowed");
        }
    }
}

