/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.mapreduce;

import hivemall.hcatalog.common.HCatUtil;
import hivemall.hcatalog.mapreduce.FileOutputFormatContainer;
import hivemall.hcatalog.mapreduce.HCatFileUtil;
import hivemall.hcatalog.mapreduce.OutputFormatContainer;
import hivemall.hcatalog.mapreduce.OutputJobInfo;
import hivemall.hcatalog.mapreduce.SpecialCases;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;

public class FosterStorageHandler
extends DefaultStorageHandler {
    public Configuration conf;
    protected static final String TEMP_DIR_NAME = "_TEMP";
    private Class<? extends InputFormat> ifClass;
    private Class<? extends OutputFormat> ofClass;
    private Class<? extends SerDe> serDeClass;

    public FosterStorageHandler(String ifName, String ofName, String serdeName) throws ClassNotFoundException {
        this(Class.forName(ifName), Class.forName(ofName), Class.forName(serdeName));
    }

    public FosterStorageHandler(Class<? extends InputFormat> ifClass, Class<? extends OutputFormat> ofClass, Class<? extends SerDe> serDeClass) {
        this.ifClass = ifClass;
        this.ofClass = ofClass;
        this.serDeClass = serDeClass;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.ifClass;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return this.ofClass;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return this.serDeClass;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            String outputLocation;
            OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize((String)tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.info"));
            String parentPath = jobInfo.getTableInfo().getTableLocation();
            String dynHash = (String)tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.dynamic.jobid");
            String idHash = (String)tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.id");
            if (dynHash != null) {
                if (Boolean.valueOf((String)tableDesc.getProperties().get("EXTERNAL")).booleanValue() && jobInfo.getCustomDynamicRoot() != null && jobInfo.getCustomDynamicRoot().length() > 0) {
                    parentPath = new Path(parentPath, jobInfo.getCustomDynamicRoot()).toString();
                }
                parentPath = new Path(parentPath, "_DYN" + dynHash).toString();
            } else {
                parentPath = new Path(parentPath, "_SCRATCH" + idHash).toString();
            }
            if (dynHash != null && Boolean.valueOf((String)tableDesc.getProperties().get("EXTERNAL")).booleanValue() && jobInfo.getCustomDynamicPath() != null && jobInfo.getCustomDynamicPath().length() > 0) {
                outputLocation = HCatFileUtil.resolveCustomPath(jobInfo, null, true);
            } else if (dynHash == null && Boolean.valueOf((String)tableDesc.getProperties().get("EXTERNAL")).booleanValue() && jobInfo.getLocation() != null && jobInfo.getLocation().length() > 0) {
                outputLocation = jobInfo.getLocation();
            } else if (dynHash == null && jobInfo.getPartitionValues().size() == 0) {
                outputLocation = "";
            } else {
                ArrayList<String> cols = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (String name : jobInfo.getTableInfo().getPartitionColumns().getFieldNames()) {
                    String value = jobInfo.getPartitionValues().get(name);
                    cols.add(name);
                    values.add(value);
                }
                outputLocation = FileUtils.makePartName(cols, values);
            }
            if (outputLocation != null && !outputLocation.isEmpty()) {
                jobInfo.setLocation(new Path(parentPath, outputLocation).toString());
            } else {
                jobInfo.setLocation(new Path(parentPath).toString());
            }
            if (jobInfo.getPartitionValues().size() == jobInfo.getTableInfo().getPartitionColumns().size()) {
                jobProperties.put("mapred.output.dir", jobInfo.getLocation());
            }
            SpecialCases.addSpecialCasesParametersToOutputJobProperties(jobProperties, jobInfo, this.ofClass);
            jobProperties.put("mapreduce.lib.hcatoutput.info", HCatUtil.serialize(jobInfo));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set output path", e);
        }
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    OutputFormatContainer getOutputFormatContainer(OutputFormat outputFormat) {
        return new FileOutputFormatContainer(outputFormat);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }
}

