/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.mapreduce;

import hivemall.hcatalog.common.HCatUtil;
import hivemall.hcatalog.data.DefaultHCatRecord;
import hivemall.hcatalog.data.HCatRecord;
import hivemall.hcatalog.data.LazyHCatRecord;
import hivemall.hcatalog.data.schema.HCatSchema;
import hivemall.hcatalog.mapreduce.HCatInputFormat;
import hivemall.hcatalog.mapreduce.HCatSplit;
import hivemall.hcatalog.mapreduce.InternalUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HCatRecordReader
extends RecordReader<WritableComparable, HCatRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(HCatRecordReader.class);
    private InputErrorTracker errorTracker;
    WritableComparable currentKey;
    Writable currentValue;
    HCatRecord currentHCatRecord;
    private org.apache.hadoop.mapred.RecordReader<WritableComparable, Writable> baseRecordReader;
    private final HiveStorageHandler storageHandler;
    private Deserializer deserializer;
    private Map<String, String> valuesNotInDataCols;
    private HCatSchema outputSchema = null;
    private HCatSchema dataSchema = null;

    public HCatRecordReader(HiveStorageHandler storageHandler, Map<String, String> valuesNotInDataCols) {
        this.storageHandler = storageHandler;
        this.valuesNotInDataCols = valuesNotInDataCols;
    }

    public void initialize(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        HCatSplit hcatSplit = InternalUtil.castToHCatSplit(split);
        this.baseRecordReader = this.createBaseRecordReader(hcatSplit, this.storageHandler, taskContext);
        this.createDeserializer(hcatSplit, this.storageHandler, taskContext);
        this.outputSchema = (HCatSchema)HCatUtil.deserialize(taskContext.getConfiguration().get("mapreduce.lib.hcat.output.schema"));
        if (this.outputSchema == null) {
            this.outputSchema = hcatSplit.getTableSchema();
        }
        this.dataSchema = hcatSplit.getDataSchema();
        this.errorTracker = new InputErrorTracker(taskContext.getConfiguration());
    }

    private org.apache.hadoop.mapred.RecordReader createBaseRecordReader(HCatSplit hcatSplit, HiveStorageHandler storageHandler, TaskAttemptContext taskContext) throws IOException {
        JobConf jobConf = HCatUtil.getJobConfFromContext((JobContext)taskContext);
        HCatUtil.copyJobPropertiesToJobConf(hcatSplit.getPartitionInfo().getJobProperties(), jobConf);
        InputFormat<WritableComparable, Writable> inputFormat = HCatInputFormat.getMapRedInputFormat(jobConf, storageHandler.getInputFormatClass());
        return inputFormat.getRecordReader(hcatSplit.getBaseSplit(), jobConf, InternalUtil.createReporter(taskContext));
    }

    private void createDeserializer(HCatSplit hcatSplit, HiveStorageHandler storageHandler, TaskAttemptContext taskContext) throws IOException {
        this.deserializer = (Deserializer)ReflectionUtils.newInstance((Class)storageHandler.getSerDeClass(), (Configuration)taskContext.getConfiguration());
        try {
            InternalUtil.initializeDeserializer(this.deserializer, storageHandler.getConf(), hcatSplit.getPartitionInfo().getTableInfo(), hcatSplit.getPartitionInfo().getPartitionSchema());
        }
        catch (SerDeException e) {
            throw new IOException("Failed initializing deserializer " + storageHandler.getSerDeClass().getName(), e);
        }
    }

    public WritableComparable getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public HCatRecord getCurrentValue() throws IOException, InterruptedException {
        return this.currentHCatRecord;
    }

    public float getProgress() {
        try {
            return this.baseRecordReader.getProgress();
        }
        catch (IOException e) {
            LOG.warn("Exception in HCatRecord reader", (Throwable)e);
            return 0.0f;
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.currentKey == null) {
            this.currentKey = (WritableComparable)this.baseRecordReader.createKey();
            this.currentValue = (Writable)this.baseRecordReader.createValue();
        }
        while (this.baseRecordReader.next((Object)this.currentKey, (Object)this.currentValue)) {
            LazyHCatRecord r = null;
            Throwable t = null;
            this.errorTracker.incRecords();
            try {
                Object o = this.deserializer.deserialize(this.currentValue);
                r = new LazyHCatRecord(o, this.deserializer.getObjectInspector());
            }
            catch (Throwable throwable) {
                t = throwable;
            }
            if (r == null) {
                this.errorTracker.incErrors(t);
                continue;
            }
            DefaultHCatRecord dr = new DefaultHCatRecord(this.outputSchema.size());
            int i = 0;
            for (String fieldName : this.outputSchema.getFieldNames()) {
                if (this.dataSchema.getPosition(fieldName) != null) {
                    dr.set(i, ((HCatRecord)r).get(fieldName, this.dataSchema));
                } else {
                    dr.set(i, this.valuesNotInDataCols.get(fieldName));
                }
                ++i;
            }
            this.currentHCatRecord = dr;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.baseRecordReader.close();
    }

    static class InputErrorTracker {
        long numRecords;
        long numErrors;
        double errorThreshold;
        long minErrors;

        InputErrorTracker(Configuration conf) {
            this.errorThreshold = conf.getFloat("hcat.input.bad.record.threshold", 1.0E-4f);
            this.minErrors = conf.getLong("hcat.input.bad.record.min", 2L);
            this.numRecords = 0L;
            this.numErrors = 0L;
        }

        void incRecords() {
            ++this.numRecords;
        }

        void incErrors(Throwable cause) {
            ++this.numErrors;
            if (this.numErrors > this.numRecords) {
                throw new RuntimeException("Forgot to invoke incRecords()?");
            }
            if (cause == null) {
                cause = new Exception("Unknown error");
            }
            if (this.errorThreshold <= 0.0) {
                throw new RuntimeException("error while reading input records", cause);
            }
            LOG.warn("Error while reading an input record (" + this.numErrors + " out of " + this.numRecords + " so far ): ", cause);
            double errRate = (double)this.numErrors / (double)this.numRecords;
            if (this.numErrors >= this.minErrors && errRate > this.errorThreshold) {
                LOG.error(this.numErrors + " out of " + this.numRecords + " crosses configured threshold (" + this.errorThreshold + ")");
                throw new RuntimeException("error rate while reading input records crossed threshold", cause);
            }
        }
    }
}

