/*
 * Decompiled with CFR 0.152.
 */
package hivemall.hcatalog.mapreduce;

import hivemall.hcatalog.mapreduce.HCatTableInfo;
import hivemall.hcatalog.mapreduce.PartInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InputJobInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private HCatTableInfo tableInfo;
    private String filter;
    private transient List<PartInfo> partitions;
    private Properties properties;

    public static InputJobInfo create(String databaseName, String tableName, String filter, Properties properties) {
        return new InputJobInfo(databaseName, tableName, filter, properties);
    }

    @Deprecated
    public static InputJobInfo create(String databaseName, String tableName, String filter) {
        return InputJobInfo.create(databaseName, tableName, filter, null);
    }

    private InputJobInfo(String databaseName, String tableName, String filter, Properties properties) {
        this.databaseName = databaseName == null ? "default" : databaseName;
        this.tableName = tableName;
        this.filter = filter;
        this.properties = properties == null ? new Properties() : properties;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HCatTableInfo getTableInfo() {
        return this.tableInfo;
    }

    void setTableInfo(HCatTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<PartInfo> getPartitions() {
        return this.partitions;
    }

    void setPartitions(List<PartInfo> partitions) {
        this.partitions = partitions;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        Deflater def = new Deflater(9);
        ObjectOutputStream partInfoWriter = new ObjectOutputStream(new DeflaterOutputStream((OutputStream)oos, def));
        partInfoWriter.writeObject(this.partitions);
        partInfoWriter.close();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ObjectInputStream partInfoReader = new ObjectInputStream(new InflaterInputStream(ois));
        this.partitions = (List)partInfoReader.readObject();
    }
}

