/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.distance;

import hivemall.model.FeatureValue;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;

@Description(name="euclid_distance", value="_FUNC_(ftvec1, ftvec2) - Returns the square root of the sum of the squared differences: sqrt(sum((x - y)^2))", extended="WITH docs as (\n  select 1 as docid, array('apple:1.0', 'orange:2.0', 'banana:1.0', 'kuwi:0') as features\n  union all\n  select 2 as docid, array('apple:1.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n  union all\n  select 3 as docid, array('apple:2.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n) \nselect\n  l.docid as doc1,\n  r.docid as doc2,\n  euclid_distance(l.features, r.features) as distance,\n  distance2similarity(euclid_distance(l.features, r.features)) as similarity\nfrom \n  docs l\n  CROSS JOIN docs r\nwhere\n  l.docid != r.docid\norder by \n  doc1 asc,\n  distance asc;\n\ndoc1    doc2    distance        similarity\n1       2       2.4494898       0.28989795\n1       3       2.6457512       0.2742919\n2       3       1.0     0.5\n2       1       2.4494898       0.28989795\n3       2       1.0     0.5\n3       1       2.6457512       0.2742919")
@UDFType(deterministic=true, stateful=false)
public final class EuclidDistanceUDF
extends GenericUDF {
    private ListObjectInspector arg0ListOI;
    private ListObjectInspector arg1ListOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("euclid_distance takes 2 arguments");
        }
        this.arg0ListOI = HiveUtils.asListOI(argOIs[0]);
        this.arg1ListOI = HiveUtils.asListOI(argOIs[1]);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        List<String> ftvec1 = HiveUtils.asStringList(arguments[0], this.arg0ListOI);
        List<String> ftvec2 = HiveUtils.asStringList(arguments[1], this.arg1ListOI);
        float d = (float)EuclidDistanceUDF.euclidDistance(ftvec1, ftvec2);
        return new FloatWritable(d);
    }

    public static double euclidDistance(List<String> ftvec1, List<String> ftvec2) {
        FeatureValue probe = new FeatureValue();
        HashMap<String, Float> map = new HashMap<String, Float>(ftvec1.size() * 2 + 1);
        for (String ft : ftvec1) {
            if (ft == null) continue;
            FeatureValue.parseFeatureAsString(ft, probe);
            float v1 = probe.getValueAsFloat();
            String string = (String)probe.getFeature();
            map.put(string, Float.valueOf(v1));
        }
        double d = 0.0;
        for (String string : ftvec2) {
            if (string == null) continue;
            FeatureValue.parseFeatureAsString(string, probe);
            String f2 = (String)probe.getFeature();
            float v2f = probe.getValueAsFloat();
            Float v1 = (Float)map.remove(f2);
            if (v1 == null) {
                d += (double)(v2f * v2f);
                continue;
            }
            float v1f = v1.floatValue();
            float diff = v1f - v2f;
            d += (double)(diff * diff);
        }
        for (Map.Entry entry : map.entrySet()) {
            float v1f = ((Float)entry.getValue()).floatValue();
            d += (double)(v1f * v1f);
        }
        return Math.sqrt(d);
    }

    public String getDisplayString(String[] children) {
        return "euclid_distance(" + Arrays.toString(children) + ")";
    }
}

