/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.distance;

import hivemall.utils.hadoop.WritableUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="hamming_distance", value="_FUNC_(integer A, integer B) - Returns Hamming distance between A and B", extended="select \n  hamming_distance(0,3) as c1, \n  hamming_distance(\"0\",\"3\") as c2 -- 0=0x00, 3=0x11\n;\n\nc1      c2\n2       2")
@UDFType(deterministic=true, stateful=false)
public class HammingDistanceUDF
extends UDF {
    public IntWritable evaluate(long a, long b) {
        return WritableUtils.val(HammingDistanceUDF.hammingDistance(a, b));
    }

    public IntWritable evaluate(String a, String b) {
        BigInteger ai = new BigInteger(a);
        BigInteger bi = new BigInteger(b);
        return WritableUtils.val(HammingDistanceUDF.hammingDistance(ai, bi));
    }

    public IntWritable evaluate(List<LongWritable> a, List<LongWritable> b) {
        List<LongWritable> r;
        int max;
        int min;
        int blen;
        int alen = a.size();
        if (alen < (blen = b.size())) {
            min = alen;
            max = blen;
            r = b;
        } else {
            min = blen;
            max = alen;
            r = a;
        }
        int result = 0;
        for (int i = 0; i < min; ++i) {
            result += HammingDistanceUDF.hammingDistance(a.get(i).get(), b.get(i).get());
        }
        for (int j = min; j < max; ++j) {
            result += HammingDistanceUDF.hammingDistance(0L, r.get(j).get());
        }
        return WritableUtils.val(result);
    }

    public static int hammingDistance(long a, long b) {
        return Long.bitCount(a ^ b);
    }

    public static int hammingDistance(BigInteger a, BigInteger b) {
        BigInteger xor = a.xor(b);
        return xor.bitCount();
    }
}

