/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.distance;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;

@Description(name="kld", value="_FUNC_(double mu1, double sigma1, double mu2, double sigma2) - Returns KL divergence between two distributions")
@UDFType(deterministic=true, stateful=false)
public final class KLDivergenceUDF
extends UDF {
    public DoubleWritable evaluate(double mu1, double sigma1, double mu2, double sigma2) {
        double d = KLDivergenceUDF.kld(mu1, sigma1, mu2, sigma2);
        return new DoubleWritable(d);
    }

    public FloatWritable evaluate(float mu1, float sigma1, float mu2, float sigma2) {
        float f = (float)KLDivergenceUDF.kld(mu1, sigma1, mu2, sigma2);
        return new FloatWritable(f);
    }

    public static double kld(double mu1, double sigma1, double mu2, double sigma2) {
        return (Math.log(sigma2 / sigma1) + sigma2 / sigma1 + Math.pow(mu1 - mu2, 2.0) / sigma2 - 1.0) * 0.5;
    }
}

