/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.distance;

import hivemall.model.FeatureValue;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;

@Description(name="minkowski_distance", value="_FUNC_(list x, list y, double p) - Returns sum(|x - y|^p)^(1/p)", extended="WITH docs as (\n  select 1 as docid, array('apple:1.0', 'orange:2.0', 'banana:1.0', 'kuwi:0') as features\n  union all\n  select 2 as docid, array('apple:1.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n  union all\n  select 3 as docid, array('apple:2.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n) \nselect\n  l.docid as doc1,\n  r.docid as doc2,\n  minkowski_distance(l.features, r.features, 1) as distance1, -- p=1 (manhattan_distance)\n  minkowski_distance(l.features, r.features, 2) as distance2, -- p=2 (euclid_distance)\n  minkowski_distance(l.features, r.features, 3) as distance3, -- p=3\n  manhattan_distance(l.features, r.features) as manhattan_distance,\n  euclid_distance(l.features, r.features) as euclid_distance\nfrom \n  docs l\n  CROSS JOIN docs r\nwhere\n  l.docid != r.docid\norder by \n  doc1 asc,\n  distance1 asc;\n\ndoc1    doc2    distance1       distance2       distance3       manhattan_distance      euclid_distance\n1       2       4.0     2.4494898       2.1544347       4.0     2.4494898\n1       3       5.0     2.6457512       2.2239802       5.0     2.6457512\n2       3       1.0     1.0     1.0     1.0     1.0\n2       1       4.0     2.4494898       2.1544347       4.0     2.4494898\n3       2       1.0     1.0     1.0     1.0     1.0\n3       1       5.0     2.6457512       2.2239802       5.0     2.6457512")
@UDFType(deterministic=true, stateful=false)
public final class MinkowskiDistanceUDF
extends GenericUDF {
    private ListObjectInspector arg0ListOI;
    private ListObjectInspector arg1ListOI;
    private double order_p;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 3) {
            throw new UDFArgumentException("minkowski_distance takes 3 arguments");
        }
        this.arg0ListOI = HiveUtils.asListOI(argOIs, 0);
        this.arg1ListOI = HiveUtils.asListOI(argOIs, 1);
        this.order_p = HiveUtils.getAsConstDouble(argOIs[2]);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        List<String> ftvec1 = HiveUtils.asStringList(arguments[0], this.arg0ListOI);
        List<String> ftvec2 = HiveUtils.asStringList(arguments[1], this.arg1ListOI);
        float d = (float)MinkowskiDistanceUDF.minkowskiDistance(ftvec1, ftvec2, this.order_p);
        return new FloatWritable(d);
    }

    public static double minkowskiDistance(List<String> ftvec1, List<String> ftvec2, double orderP) {
        FeatureValue probe = new FeatureValue();
        HashMap<String, Float> map = new HashMap<String, Float>(ftvec1.size() * 2 + 1);
        for (String ft : ftvec1) {
            if (ft == null) continue;
            FeatureValue.parseFeatureAsString(ft, probe);
            float v1 = probe.getValueAsFloat();
            String string = (String)probe.getFeature();
            map.put(string, Float.valueOf(v1));
        }
        double d = 0.0;
        for (String string : ftvec2) {
            if (string == null) continue;
            FeatureValue.parseFeatureAsString(string, probe);
            String f2 = (String)probe.getFeature();
            float v2f = probe.getValueAsFloat();
            Float v1 = (Float)map.remove(f2);
            if (v1 == null) {
                d += (double)Math.abs(v2f);
                continue;
            }
            float v1f = v1.floatValue();
            d += Math.pow(Math.abs(v1f - v2f), orderP);
        }
        for (Map.Entry entry : map.entrySet()) {
            float v1f = ((Float)entry.getValue()).floatValue();
            d += Math.pow(Math.abs(v1f), orderP);
        }
        return Math.pow(d, 1.0 / orderP);
    }

    public String getDisplayString(String[] children) {
        return "minkowski_distance(" + Arrays.toString(children) + ")";
    }
}

