/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.similarity;

import hivemall.model.FeatureValue;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;

@Description(name="cosine_similarity", value="_FUNC_(ftvec1, ftvec2) - Returns a cosine similarity of the given two vectors", extended="WITH docs as (\n  select 1 as docid, array('apple:1.0', 'orange:2.0', 'banana:1.0', 'kuwi:0') as features\n  union all\n  select 2 as docid, array('apple:1.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n  union all\n  select 3 as docid, array('apple:2.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n) \nselect\n  l.docid as doc1,\n  r.docid as doc2,\n  cosine_similarity(l.features, r.features) as similarity\nfrom \n  docs l\n  CROSS JOIN docs r\nwhere\n  l.docid != r.docid\norder by \n  doc1 asc,\n  similarity desc;\n\ndoc1    doc2    similarity\n1       3       0.5443311\n1       2       0.5\n2       3       0.9525793\n2       1       0.5\n3       2       0.9525793\n3       1       0.5443311")
@UDFType(deterministic=true, stateful=false)
public final class CosineSimilarityUDF
extends GenericUDF {
    private ListObjectInspector arg0ListOI;
    private ListObjectInspector arg1ListOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("cosine_similarity takes 2 arguments");
        }
        this.arg0ListOI = HiveUtils.asListOI(argOIs, 0);
        this.arg1ListOI = HiveUtils.asListOI(argOIs, 1);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        List<String> ftvec1 = HiveUtils.asStringList(arguments[0], this.arg0ListOI);
        List<String> ftvec2 = HiveUtils.asStringList(arguments[1], this.arg1ListOI);
        float similarity = CosineSimilarityUDF.cosineSimilarity(ftvec1, ftvec2);
        return new FloatWritable(similarity);
    }

    public static float cosineSimilarity(List<String> ftvec1, List<String> ftvec2) {
        if (ftvec1 == null || ftvec2 == null) {
            return 0.0f;
        }
        FeatureValue probe = new FeatureValue();
        HashMap<String, Float> map1 = new HashMap<String, Float>(ftvec1.size() * 2 + 1);
        double score1 = 0.0;
        for (String ft : ftvec1) {
            FeatureValue.parseFeatureAsString(ft, probe);
            float v = probe.getValueAsFloat();
            score1 += (double)(v * v);
            String f = (String)probe.getFeature();
            map1.put(f, Float.valueOf(v));
        }
        double l1norm1 = Math.sqrt(score1);
        float dotp = 0.0f;
        double score2 = 0.0;
        for (String ft : ftvec2) {
            FeatureValue.parseFeatureAsString(ft, probe);
            float v2 = probe.getValueAsFloat();
            score2 += (double)(v2 * v2);
            String f2 = (String)probe.getFeature();
            Float v1 = (Float)map1.get(f2);
            if (v1 == null) continue;
            dotp += v1.floatValue() * v2;
        }
        double l1norm2 = Math.sqrt(score2);
        double denom = l1norm1 * l1norm2;
        if (denom <= 0.0) {
            return 0.0f;
        }
        return (float)((double)dotp / denom);
    }

    public String getDisplayString(String[] children) {
        return "cosine_similarity(" + Arrays.toString(children) + ")";
    }
}

