/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.similarity;

import hivemall.knn.distance.EuclidDistanceUDF;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;

@Description(name="euclid_similarity", value="_FUNC_(ftvec1, ftvec2) - Returns a euclid distance based similarity, which is `1.0 / (1.0 + distance)`, of the given two vectors", extended="WITH docs as (\n  select 1 as docid, array('apple:1.0', 'orange:2.0', 'banana:1.0', 'kuwi:0') as features\n  union all\n  select 2 as docid, array('apple:1.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n  union all\n  select 3 as docid, array('apple:2.0', 'orange:0', 'banana:2.0', 'kuwi:1.0') as features\n) \nselect\n  l.docid as doc1,\n  r.docid as doc2,\n  euclid_similarity(l.features, r.features) as similarity\nfrom \n  docs l\n  CROSS JOIN docs r\nwhere\n  l.docid != r.docid\norder by \n  doc1 asc,\n  similarity desc;\n\ndoc1    doc2    similarity\n1       2       0.28989795\n1       3       0.2742919\n2       3       0.5\n2       1       0.28989795\n3       2       0.5\n3       1       0.2742919")
@UDFType(deterministic=true, stateful=false)
public final class EuclidSimilarity
extends GenericUDF {
    private ListObjectInspector arg0ListOI;
    private ListObjectInspector arg1ListOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("euclid_similarity takes 2 arguments");
        }
        this.arg0ListOI = HiveUtils.asListOI(argOIs, 0);
        this.arg1ListOI = HiveUtils.asListOI(argOIs, 1);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        List<String> ftvec1 = HiveUtils.asStringList(arguments[0], this.arg0ListOI);
        List<String> ftvec2 = HiveUtils.asStringList(arguments[1], this.arg1ListOI);
        float d = (float)EuclidDistanceUDF.euclidDistance(ftvec1, ftvec2);
        float sim = 1.0f / (1.0f + d);
        return new FloatWritable(sim);
    }

    public String getDisplayString(String[] children) {
        return "euclid_similarity(" + Arrays.toString(children) + ")";
    }
}

