/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class MixMessage
implements Externalizable {
    private MixEventName event;
    private Object feature;
    private float weight;
    private float covariance;
    private short clock;
    private int deltaUpdates;
    private boolean cancelRequest;
    private String groupID;

    public MixMessage() {
    }

    public MixMessage(MixEventName event, Object feature, float weight, short clock, int deltaUpdates) {
        this(event, feature, weight, 0.0f, clock, deltaUpdates, false);
    }

    public MixMessage(MixEventName event, Object feature, float weight, float covariance, short clock, int deltaUpdates) {
        this(event, feature, weight, covariance, clock, deltaUpdates, false);
    }

    public MixMessage(MixEventName event, Object feature, float weight, float covariance, int deltaUpdates, boolean cancelRequest) {
        this(event, feature, weight, covariance, 0, deltaUpdates, cancelRequest);
    }

    MixMessage(MixEventName event, Object feature, float weight, float covariance, short clock, int deltaUpdates, boolean cancelRequest) {
        if (feature == null) {
            throw new IllegalArgumentException("feature is null");
        }
        if (deltaUpdates < 0 || deltaUpdates > 127) {
            throw new IllegalArgumentException("Illegal deltaUpdates: " + deltaUpdates);
        }
        this.event = event;
        this.feature = feature;
        this.weight = weight;
        this.covariance = covariance;
        this.clock = clock;
        this.deltaUpdates = deltaUpdates;
        this.cancelRequest = cancelRequest;
    }

    public MixEventName getEvent() {
        return this.event;
    }

    public Object getFeature() {
        return this.feature;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getCovariance() {
        return this.covariance;
    }

    public short getClock() {
        return this.clock;
    }

    public int getDeltaUpdates() {
        return this.deltaUpdates;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public boolean isCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.event.getID());
        out.writeObject(this.feature);
        out.writeFloat(this.weight);
        out.writeFloat(this.covariance);
        out.writeShort(this.clock);
        out.writeInt(this.deltaUpdates);
        out.writeBoolean(this.cancelRequest);
        if (this.groupID == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.groupID);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte id = in.readByte();
        this.event = MixEventName.resolve(id);
        this.feature = in.readObject();
        this.weight = in.readFloat();
        this.covariance = in.readFloat();
        this.clock = in.readShort();
        this.deltaUpdates = in.readInt();
        this.cancelRequest = in.readBoolean();
        boolean hasGroupID = in.readBoolean();
        if (hasGroupID) {
            this.groupID = in.readUTF();
        }
    }

    public String toString() {
        return "MixMessage [event=" + (Object)((Object)this.event) + ", feature=" + this.feature + ", weight=" + this.weight + ", covariance=" + this.covariance + ", clock=" + this.clock + ", deltaUpdates=" + this.deltaUpdates + ", cancel=" + this.cancelRequest + ", groupID=" + this.groupID + "]";
    }

    public static enum MixEventName {
        average(1),
        argminKLD(2),
        closeGroup(3);

        private final byte id;

        private MixEventName(byte id) {
            this.id = id;
        }

        public byte getID() {
            return this.id;
        }

        public static MixEventName resolve(int b) {
            switch (b) {
                case 1: {
                    return average;
                }
                case 2: {
                    return argminKLD;
                }
            }
            throw new IllegalArgumentException("Illegal ID: " + b);
        }
    }
}

