/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.annotations.InternalAPI;
import hivemall.mix.MixedWeight;
import hivemall.model.IWeightValue;
import hivemall.model.ModelUpdateHandler;
import hivemall.model.PredictionModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPredictionModel
implements PredictionModel {
    public static final byte BYTE0 = 0;
    @Nullable
    protected ModelUpdateHandler handler;
    private long numMixed = 0L;
    private boolean cancelMixRequest = false;
    private Int2ObjectMap<MixedWeight> mixedRequests_i;
    private Object2ObjectMap<Object, MixedWeight> mixedRequests_o;

    protected abstract boolean isDenseModel();

    @Override
    public ModelUpdateHandler getUpdateHandler() {
        return this.handler;
    }

    @Override
    public void configureMix(@Nonnull ModelUpdateHandler handler, boolean cancelMixRequest) {
        this.handler = handler;
        this.cancelMixRequest = cancelMixRequest;
        if (cancelMixRequest) {
            if (this.isDenseModel()) {
                this.mixedRequests_i = new Int2ObjectOpenHashMap<MixedWeight>(327680);
            } else {
                this.mixedRequests_o = new Object2ObjectOpenHashMap<Object, MixedWeight>(327680);
            }
        }
    }

    @Override
    public final long getNumMixed() {
        return this.numMixed;
    }

    @Override
    public void resetDeltaUpdates(int feature) {
        throw new UnsupportedOperationException();
    }

    protected final void onUpdate(int feature, float weight, float covar, short clock, int deltaUpdates, boolean hasCovar) {
        if (this.handler != null) {
            boolean requestSent;
            if (deltaUpdates < 1) {
                return;
            }
            try {
                requestSent = this.handler.onUpdate(feature, weight, covar, clock, deltaUpdates);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (requestSent) {
                if (this.cancelMixRequest) {
                    if (hasCovar) {
                        MixedWeight prevMixed = (MixedWeight)this.mixedRequests_i.get(feature);
                        if (prevMixed == null) {
                            prevMixed = new MixedWeight.WeightWithCovar(weight, covar);
                            this.mixedRequests_i.put(feature, prevMixed);
                        } else {
                            try {
                                this.handler.sendCancelRequest(feature, prevMixed);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            prevMixed.setWeight(weight);
                            prevMixed.setCovar(covar);
                        }
                    } else {
                        MixedWeight prevMixed = (MixedWeight)this.mixedRequests_i.get(feature);
                        if (prevMixed == null) {
                            prevMixed = new MixedWeight.WeightWithDelta(weight, deltaUpdates);
                            this.mixedRequests_i.put(feature, prevMixed);
                        } else {
                            try {
                                this.handler.sendCancelRequest(feature, prevMixed);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            prevMixed.setWeight(weight);
                            prevMixed.setDeltaUpdates(deltaUpdates);
                        }
                    }
                }
                this.resetDeltaUpdates(feature);
            }
        }
    }

    protected final void onUpdate(Object feature, IWeightValue value) {
        if (this.handler != null) {
            if (!value.isTouched()) {
                return;
            }
            float weight = value.get();
            short clock = value.getClock();
            byte deltaUpdates = value.getDeltaUpdates();
            if (value.hasCovariance()) {
                boolean requestSent;
                float covar = value.getCovariance();
                try {
                    requestSent = this.handler.onUpdate(feature, weight, covar, clock, deltaUpdates);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (requestSent) {
                    if (this.cancelMixRequest) {
                        MixedWeight prevMixed = (MixedWeight)this.mixedRequests_o.get(feature);
                        if (prevMixed == null) {
                            prevMixed = new MixedWeight.WeightWithCovar(weight, covar);
                            this.mixedRequests_o.put(feature, prevMixed);
                        } else {
                            try {
                                this.handler.sendCancelRequest(feature, prevMixed);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            prevMixed.setWeight(weight);
                            prevMixed.setCovar(covar);
                        }
                    }
                    value.setDeltaUpdates((byte)0);
                }
            } else {
                boolean requestSent;
                try {
                    requestSent = this.handler.onUpdate(feature, weight, 1.0f, clock, deltaUpdates);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (requestSent) {
                    if (this.cancelMixRequest) {
                        MixedWeight prevMixed = (MixedWeight)this.mixedRequests_o.get(feature);
                        if (prevMixed == null) {
                            prevMixed = new MixedWeight.WeightWithDelta(weight, deltaUpdates);
                            this.mixedRequests_o.put(feature, prevMixed);
                        } else {
                            try {
                                this.handler.sendCancelRequest(feature, prevMixed);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            prevMixed.setWeight(weight);
                            prevMixed.setDeltaUpdates(deltaUpdates);
                        }
                    }
                    value.setDeltaUpdates((byte)0);
                }
            }
        }
    }

    @Override
    public void set(@Nonnull Object feature, float weight, float covar, short clock) {
        if (this.hasCovariance()) {
            this._set(feature, weight, covar, clock);
        } else {
            this._set(feature, weight, clock);
        }
        ++this.numMixed;
    }

    @InternalAPI
    protected abstract void _set(@Nonnull Object var1, float var2, short var3);

    @InternalAPI
    protected abstract void _set(@Nonnull Object var1, float var2, float var3, short var4);
}

